/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.Target;

public class TargetJsonMarshaller {
    private static TargetJsonMarshaller instance;

    public void marshall(Target target, StructuredJsonGenerator jsonGenerator) {
        if (target == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList valuesList;
            jsonGenerator.writeStartObject();
            if (target.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(target.getKey());
            }
            if (!(valuesList = (SdkInternalList)target.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Values");
                jsonGenerator.writeStartArray();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonGenerator.writeValue(valuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TargetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TargetJsonMarshaller();
        }
        return instance;
    }
}

