/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterHistoryRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetParameterHistoryRequestMarshaller
implements Marshaller<Request<GetParameterHistoryRequest>, GetParameterHistoryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetParameterHistoryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetParameterHistoryRequest> marshall(GetParameterHistoryRequest getParameterHistoryRequest) {
        if (getParameterHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getParameterHistoryRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.GetParameterHistory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getParameterHistoryRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(getParameterHistoryRequest.getName());
            }
            if (getParameterHistoryRequest.getWithDecryption() != null) {
                jsonGenerator.writeFieldName("WithDecryption").writeValue(getParameterHistoryRequest.getWithDecryption().booleanValue());
            }
            if (getParameterHistoryRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(getParameterHistoryRequest.getMaxResults().intValue());
            }
            if (getParameterHistoryRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getParameterHistoryRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

