/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CreateMaintenanceWindowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateMaintenanceWindowRequestMarshaller
implements Marshaller<Request<CreateMaintenanceWindowRequest>, CreateMaintenanceWindowRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateMaintenanceWindowRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateMaintenanceWindowRequest> marshall(CreateMaintenanceWindowRequest createMaintenanceWindowRequest) {
        if (createMaintenanceWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMaintenanceWindowRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreateMaintenanceWindow");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createMaintenanceWindowRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createMaintenanceWindowRequest.getName());
            }
            if (createMaintenanceWindowRequest.getSchedule() != null) {
                jsonGenerator.writeFieldName("Schedule").writeValue(createMaintenanceWindowRequest.getSchedule());
            }
            if (createMaintenanceWindowRequest.getDuration() != null) {
                jsonGenerator.writeFieldName("Duration").writeValue(createMaintenanceWindowRequest.getDuration().intValue());
            }
            if (createMaintenanceWindowRequest.getCutoff() != null) {
                jsonGenerator.writeFieldName("Cutoff").writeValue(createMaintenanceWindowRequest.getCutoff().intValue());
            }
            if (createMaintenanceWindowRequest.getAllowUnassociatedTargets() != null) {
                jsonGenerator.writeFieldName("AllowUnassociatedTargets").writeValue(createMaintenanceWindowRequest.getAllowUnassociatedTargets().booleanValue());
            }
            jsonGenerator.writeFieldName("ClientToken").writeValue(IdempotentUtils.resolveString((String)createMaintenanceWindowRequest.getClientToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

