/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servermigration.model.VmServer;
import com.amazonaws.services.servermigration.model.transform.VmServerAddressJsonMarshaller;

public class VmServerJsonMarshaller {
    private static VmServerJsonMarshaller instance;

    public void marshall(VmServer vmServer, StructuredJsonGenerator jsonGenerator) {
        if (vmServer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (vmServer.getVmServerAddress() != null) {
                jsonGenerator.writeFieldName("vmServerAddress");
                VmServerAddressJsonMarshaller.getInstance().marshall(vmServer.getVmServerAddress(), jsonGenerator);
            }
            if (vmServer.getVmName() != null) {
                jsonGenerator.writeFieldName("vmName").writeValue(vmServer.getVmName());
            }
            if (vmServer.getVmManagerName() != null) {
                jsonGenerator.writeFieldName("vmManagerName").writeValue(vmServer.getVmManagerName());
            }
            if (vmServer.getVmManagerType() != null) {
                jsonGenerator.writeFieldName("vmManagerType").writeValue(vmServer.getVmManagerType());
            }
            if (vmServer.getVmPath() != null) {
                jsonGenerator.writeFieldName("vmPath").writeValue(vmServer.getVmPath());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VmServerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VmServerJsonMarshaller();
        }
        return instance;
    }
}

