/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servermigration.model.ReplicationJob;
import com.amazonaws.services.servermigration.model.ReplicationRun;
import com.amazonaws.services.servermigration.model.transform.ReplicationRunJsonMarshaller;
import com.amazonaws.services.servermigration.model.transform.VmServerJsonMarshaller;
import java.util.List;

public class ReplicationJobJsonMarshaller {
    private static ReplicationJobJsonMarshaller instance;

    public void marshall(ReplicationJob replicationJob, StructuredJsonGenerator jsonGenerator) {
        if (replicationJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ReplicationRun> replicationRunListList;
            jsonGenerator.writeStartObject();
            if (replicationJob.getReplicationJobId() != null) {
                jsonGenerator.writeFieldName("replicationJobId").writeValue(replicationJob.getReplicationJobId());
            }
            if (replicationJob.getServerId() != null) {
                jsonGenerator.writeFieldName("serverId").writeValue(replicationJob.getServerId());
            }
            if (replicationJob.getServerType() != null) {
                jsonGenerator.writeFieldName("serverType").writeValue(replicationJob.getServerType());
            }
            if (replicationJob.getVmServer() != null) {
                jsonGenerator.writeFieldName("vmServer");
                VmServerJsonMarshaller.getInstance().marshall(replicationJob.getVmServer(), jsonGenerator);
            }
            if (replicationJob.getSeedReplicationTime() != null) {
                jsonGenerator.writeFieldName("seedReplicationTime").writeValue(replicationJob.getSeedReplicationTime());
            }
            if (replicationJob.getFrequency() != null) {
                jsonGenerator.writeFieldName("frequency").writeValue(replicationJob.getFrequency().intValue());
            }
            if (replicationJob.getNextReplicationRunStartTime() != null) {
                jsonGenerator.writeFieldName("nextReplicationRunStartTime").writeValue(replicationJob.getNextReplicationRunStartTime());
            }
            if (replicationJob.getLicenseType() != null) {
                jsonGenerator.writeFieldName("licenseType").writeValue(replicationJob.getLicenseType());
            }
            if (replicationJob.getRoleName() != null) {
                jsonGenerator.writeFieldName("roleName").writeValue(replicationJob.getRoleName());
            }
            if (replicationJob.getLatestAmiId() != null) {
                jsonGenerator.writeFieldName("latestAmiId").writeValue(replicationJob.getLatestAmiId());
            }
            if (replicationJob.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(replicationJob.getState());
            }
            if (replicationJob.getStatusMessage() != null) {
                jsonGenerator.writeFieldName("statusMessage").writeValue(replicationJob.getStatusMessage());
            }
            if (replicationJob.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(replicationJob.getDescription());
            }
            if ((replicationRunListList = replicationJob.getReplicationRunList()) != null) {
                jsonGenerator.writeFieldName("replicationRunList");
                jsonGenerator.writeStartArray();
                for (ReplicationRun replicationRunListListValue : replicationRunListList) {
                    if (replicationRunListListValue == null) continue;
                    ReplicationRunJsonMarshaller.getInstance().marshall(replicationRunListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationJobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationJobJsonMarshaller();
        }
        return instance;
    }
}

