/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.Rule;
import java.util.Map;

public class RuleJsonMarshaller {
    private static RuleJsonMarshaller instance;

    public void marshall(Rule rule, StructuredJsonGenerator jsonGenerator) {
        if (rule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> parametersMap;
            jsonGenerator.writeStartObject();
            if (rule.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(rule.getType());
            }
            if ((parametersMap = rule.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeValue(parametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RuleJsonMarshaller();
        }
        return instance;
    }
}

