/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.clouddirectory.model.GetDirectoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDirectoryRequestMarshaller
implements Marshaller<Request<GetDirectoryRequest>, GetDirectoryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDirectoryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetDirectoryRequest> marshall(GetDirectoryRequest getDirectoryRequest) {
        if (getDirectoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDirectoryRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (getDirectoryRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)getDirectoryRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/directory/get";
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

