/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.OpenInstancePublicPortsRequest;
import com.amazonaws.services.lightsail.model.transform.PortInfoJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class OpenInstancePublicPortsRequestMarshaller
implements Marshaller<Request<OpenInstancePublicPortsRequest>, OpenInstancePublicPortsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public OpenInstancePublicPortsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<OpenInstancePublicPortsRequest> marshall(OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        if (openInstancePublicPortsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)openInstancePublicPortsRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.OpenInstancePublicPorts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (openInstancePublicPortsRequest.getPortInfo() != null) {
                jsonGenerator.writeFieldName("portInfo");
                PortInfoJsonMarshaller.getInstance().marshall(openInstancePublicPortsRequest.getPortInfo(), jsonGenerator);
            }
            if (openInstancePublicPortsRequest.getInstanceName() != null) {
                jsonGenerator.writeFieldName("instanceName").writeValue(openInstancePublicPortsRequest.getInstanceName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

