/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworkscm.model.RestoreServerRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RestoreServerRequestMarshaller
implements Marshaller<Request<RestoreServerRequest>, RestoreServerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RestoreServerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RestoreServerRequest> marshall(RestoreServerRequest restoreServerRequest) {
        if (restoreServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreServerRequest, "AWSOpsWorksCM");
        request.addHeader("X-Amz-Target", "OpsWorksCM_V2016_11_01.RestoreServer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (restoreServerRequest.getBackupId() != null) {
                jsonGenerator.writeFieldName("BackupId").writeValue(restoreServerRequest.getBackupId());
            }
            if (restoreServerRequest.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(restoreServerRequest.getServerName());
            }
            if (restoreServerRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(restoreServerRequest.getInstanceType());
            }
            if (restoreServerRequest.getKeyPair() != null) {
                jsonGenerator.writeFieldName("KeyPair").writeValue(restoreServerRequest.getKeyPair());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

