/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ReportTaskRunnerHeartbeatRequestMarshaller
implements Marshaller<Request<ReportTaskRunnerHeartbeatRequest>, ReportTaskRunnerHeartbeatRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ReportTaskRunnerHeartbeatRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ReportTaskRunnerHeartbeatRequest> marshall(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) {
        if (reportTaskRunnerHeartbeatRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reportTaskRunnerHeartbeatRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.ReportTaskRunnerHeartbeat");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (reportTaskRunnerHeartbeatRequest.getTaskrunnerId() != null) {
                jsonGenerator.writeFieldName("taskrunnerId").writeValue(reportTaskRunnerHeartbeatRequest.getTaskrunnerId());
            }
            if (reportTaskRunnerHeartbeatRequest.getWorkerGroup() != null) {
                jsonGenerator.writeFieldName("workerGroup").writeValue(reportTaskRunnerHeartbeatRequest.getWorkerGroup());
            }
            if (reportTaskRunnerHeartbeatRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(reportTaskRunnerHeartbeatRequest.getHostname());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

