/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.Field;

public class FieldJsonMarshaller {
    private static FieldJsonMarshaller instance;

    public void marshall(Field field, StructuredJsonGenerator jsonGenerator) {
        if (field == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (field.getKey() != null) {
                jsonGenerator.writeFieldName("key").writeValue(field.getKey());
            }
            if (field.getStringValue() != null) {
                jsonGenerator.writeFieldName("stringValue").writeValue(field.getStringValue());
            }
            if (field.getRefValue() != null) {
                jsonGenerator.writeFieldName("refValue").writeValue(field.getRefValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FieldJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FieldJsonMarshaller();
        }
        return instance;
    }
}

