/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.EventSubscription;
import com.amazonaws.services.inspector.model.Subscription;
import com.amazonaws.services.inspector.model.transform.EventSubscriptionJsonMarshaller;
import java.util.List;

public class SubscriptionJsonMarshaller {
    private static SubscriptionJsonMarshaller instance;

    public void marshall(Subscription subscription, StructuredJsonGenerator jsonGenerator) {
        if (subscription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<EventSubscription> eventSubscriptionsList;
            jsonGenerator.writeStartObject();
            if (subscription.getResourceArn() != null) {
                jsonGenerator.writeFieldName("resourceArn").writeValue(subscription.getResourceArn());
            }
            if (subscription.getTopicArn() != null) {
                jsonGenerator.writeFieldName("topicArn").writeValue(subscription.getTopicArn());
            }
            if ((eventSubscriptionsList = subscription.getEventSubscriptions()) != null) {
                jsonGenerator.writeFieldName("eventSubscriptions");
                jsonGenerator.writeStartArray();
                for (EventSubscription eventSubscriptionsListValue : eventSubscriptionsList) {
                    if (eventSubscriptionsListValue == null) continue;
                    EventSubscriptionJsonMarshaller.getInstance().marshall(eventSubscriptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SubscriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SubscriptionJsonMarshaller();
        }
        return instance;
    }
}

