/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentTemplateFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListAssessmentTemplatesRequestMarshaller
implements Marshaller<Request<ListAssessmentTemplatesRequest>, ListAssessmentTemplatesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAssessmentTemplatesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAssessmentTemplatesRequest> marshall(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        if (listAssessmentTemplatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAssessmentTemplatesRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessmentTemplates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentTargetArnsList = listAssessmentTemplatesRequest.getAssessmentTargetArns();
            if (assessmentTargetArnsList != null) {
                jsonGenerator.writeFieldName("assessmentTargetArns");
                jsonGenerator.writeStartArray();
                for (String assessmentTargetArnsListValue : assessmentTargetArnsList) {
                    if (assessmentTargetArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentTargetArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAssessmentTemplatesRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentTemplateFilterJsonMarshaller.getInstance().marshall(listAssessmentTemplatesRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentTemplatesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentTemplatesRequest.getNextToken());
            }
            if (listAssessmentTemplatesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAssessmentTemplatesRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

