/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.Authorizer;
import java.util.List;

public class AuthorizerJsonMarshaller {
    private static AuthorizerJsonMarshaller instance;

    public void marshall(Authorizer authorizer, StructuredJsonGenerator jsonGenerator) {
        if (authorizer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> providerARNsList;
            jsonGenerator.writeStartObject();
            if (authorizer.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(authorizer.getId());
            }
            if (authorizer.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(authorizer.getName());
            }
            if (authorizer.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(authorizer.getType());
            }
            if ((providerARNsList = authorizer.getProviderARNs()) != null) {
                jsonGenerator.writeFieldName("providerARNs");
                jsonGenerator.writeStartArray();
                for (String providerARNsListValue : providerARNsList) {
                    if (providerARNsListValue == null) continue;
                    jsonGenerator.writeValue(providerARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (authorizer.getAuthType() != null) {
                jsonGenerator.writeFieldName("authType").writeValue(authorizer.getAuthType());
            }
            if (authorizer.getAuthorizerUri() != null) {
                jsonGenerator.writeFieldName("authorizerUri").writeValue(authorizer.getAuthorizerUri());
            }
            if (authorizer.getAuthorizerCredentials() != null) {
                jsonGenerator.writeFieldName("authorizerCredentials").writeValue(authorizer.getAuthorizerCredentials());
            }
            if (authorizer.getIdentitySource() != null) {
                jsonGenerator.writeFieldName("identitySource").writeValue(authorizer.getIdentitySource());
            }
            if (authorizer.getIdentityValidationExpression() != null) {
                jsonGenerator.writeFieldName("identityValidationExpression").writeValue(authorizer.getIdentityValidationExpression());
            }
            if (authorizer.getAuthorizerResultTtlInSeconds() != null) {
                jsonGenerator.writeFieldName("authorizerResultTtlInSeconds").writeValue(authorizer.getAuthorizerResultTtlInSeconds().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AuthorizerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AuthorizerJsonMarshaller();
        }
        return instance;
    }
}

