/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TargetInstances;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;

public class TargetInstancesJsonMarshaller {
    private static TargetInstancesJsonMarshaller instance;

    public void marshall(TargetInstances targetInstances, StructuredJsonGenerator jsonGenerator) {
        if (targetInstances == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList autoScalingGroupsList;
            jsonGenerator.writeStartObject();
            SdkInternalList tagFiltersList = (SdkInternalList)targetInstances.getTagFilters();
            if (!tagFiltersList.isEmpty() || !tagFiltersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tagFilters");
                jsonGenerator.writeStartArray();
                for (EC2TagFilter tagFiltersListValue : tagFiltersList) {
                    if (tagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall(tagFiltersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)targetInstances.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (String autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonGenerator.writeValue(autoScalingGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TargetInstancesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TargetInstancesJsonMarshaller();
        }
        return instance;
    }
}

