/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.EventDetails;
import com.amazonaws.services.health.model.transform.EventDescriptionJsonMarshaller;
import com.amazonaws.services.health.model.transform.EventJsonMarshaller;
import java.util.Map;

public class EventDetailsJsonMarshaller {
    private static EventDetailsJsonMarshaller instance;

    public void marshall(EventDetails eventDetails, StructuredJsonGenerator jsonGenerator) {
        if (eventDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> eventMetadataMap;
            jsonGenerator.writeStartObject();
            if (eventDetails.getEvent() != null) {
                jsonGenerator.writeFieldName("event");
                EventJsonMarshaller.getInstance().marshall(eventDetails.getEvent(), jsonGenerator);
            }
            if (eventDetails.getEventDescription() != null) {
                jsonGenerator.writeFieldName("eventDescription");
                EventDescriptionJsonMarshaller.getInstance().marshall(eventDetails.getEventDescription(), jsonGenerator);
            }
            if ((eventMetadataMap = eventDetails.getEventMetadata()) != null) {
                jsonGenerator.writeFieldName("eventMetadata");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> eventMetadataMapValue : eventMetadataMap.entrySet()) {
                    if (eventMetadataMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(eventMetadataMapValue.getKey());
                    jsonGenerator.writeValue(eventMetadataMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventDetailsJsonMarshaller();
        }
        return instance;
    }
}

