/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.AffectedEntity;
import java.util.Map;

public class AffectedEntityJsonMarshaller {
    private static AffectedEntityJsonMarshaller instance;

    public void marshall(AffectedEntity affectedEntity, StructuredJsonGenerator jsonGenerator) {
        if (affectedEntity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> tagsMap;
            jsonGenerator.writeStartObject();
            if (affectedEntity.getEntityArn() != null) {
                jsonGenerator.writeFieldName("entityArn").writeValue(affectedEntity.getEntityArn());
            }
            if (affectedEntity.getEventArn() != null) {
                jsonGenerator.writeFieldName("eventArn").writeValue(affectedEntity.getEventArn());
            }
            if (affectedEntity.getEntityValue() != null) {
                jsonGenerator.writeFieldName("entityValue").writeValue(affectedEntity.getEntityValue());
            }
            if (affectedEntity.getAwsAccountId() != null) {
                jsonGenerator.writeFieldName("awsAccountId").writeValue(affectedEntity.getAwsAccountId());
            }
            if (affectedEntity.getLastUpdatedTime() != null) {
                jsonGenerator.writeFieldName("lastUpdatedTime").writeValue(affectedEntity.getLastUpdatedTime());
            }
            if (affectedEntity.getStatusCode() != null) {
                jsonGenerator.writeFieldName("statusCode").writeValue(affectedEntity.getStatusCode());
            }
            if ((tagsMap = affectedEntity.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> tagsMapValue : tagsMap.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(tagsMapValue.getKey());
                    jsonGenerator.writeValue(tagsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AffectedEntityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AffectedEntityJsonMarshaller();
        }
        return instance;
    }
}

