/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.DeleteAttributesRequest;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteAttributesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        if (deleteAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAttributesRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.DeleteAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList attributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteAttributesRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(deleteAttributesRequest.getCluster());
            }
            if (!(attributesList = (SdkInternalList)deleteAttributesRequest.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

