/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.DescribeNFSFileSharesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeNFSFileSharesRequestMarshaller
implements Marshaller<Request<DescribeNFSFileSharesRequest>, DescribeNFSFileSharesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeNFSFileSharesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeNFSFileSharesRequest> marshall(DescribeNFSFileSharesRequest describeNFSFileSharesRequest) {
        if (describeNFSFileSharesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNFSFileSharesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DescribeNFSFileShares");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList fileShareARNListList = (SdkInternalList)describeNFSFileSharesRequest.getFileShareARNList();
            if (!fileShareARNListList.isEmpty() || !fileShareARNListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("FileShareARNList");
                jsonGenerator.writeStartArray();
                for (String fileShareARNListListValue : fileShareARNListList) {
                    if (fileShareARNListListValue == null) continue;
                    jsonGenerator.writeValue(fileShareARNListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

