/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.xray.model.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetTracesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Trace> traces;
    private List<String> unprocessedTraceIds;
    private String nextToken;

    public List<Trace> getTraces() {
        return this.traces;
    }

    public void setTraces(Collection<Trace> traces) {
        if (traces == null) {
            this.traces = null;
            return;
        }
        this.traces = new ArrayList<Trace>(traces);
    }

    public BatchGetTracesResult withTraces(Trace ... traces) {
        if (this.traces == null) {
            this.setTraces(new ArrayList<Trace>(traces.length));
        }
        for (Trace ele : traces) {
            this.traces.add(ele);
        }
        return this;
    }

    public BatchGetTracesResult withTraces(Collection<Trace> traces) {
        this.setTraces(traces);
        return this;
    }

    public List<String> getUnprocessedTraceIds() {
        return this.unprocessedTraceIds;
    }

    public void setUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
        if (unprocessedTraceIds == null) {
            this.unprocessedTraceIds = null;
            return;
        }
        this.unprocessedTraceIds = new ArrayList<String>(unprocessedTraceIds);
    }

    public BatchGetTracesResult withUnprocessedTraceIds(String ... unprocessedTraceIds) {
        if (this.unprocessedTraceIds == null) {
            this.setUnprocessedTraceIds(new ArrayList<String>(unprocessedTraceIds.length));
        }
        for (String ele : unprocessedTraceIds) {
            this.unprocessedTraceIds.add(ele);
        }
        return this;
    }

    public BatchGetTracesResult withUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
        this.setUnprocessedTraceIds(unprocessedTraceIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public BatchGetTracesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTraces() != null) {
            sb.append("Traces: ").append(this.getTraces()).append(",");
        }
        if (this.getUnprocessedTraceIds() != null) {
            sb.append("UnprocessedTraceIds: ").append(this.getUnprocessedTraceIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesResult)) {
            return false;
        }
        BatchGetTracesResult other = (BatchGetTracesResult)obj;
        if (other.getTraces() == null ^ this.getTraces() == null) {
            return false;
        }
        if (other.getTraces() != null && !other.getTraces().equals(this.getTraces())) {
            return false;
        }
        if (other.getUnprocessedTraceIds() == null ^ this.getUnprocessedTraceIds() == null) {
            return false;
        }
        if (other.getUnprocessedTraceIds() != null && !other.getUnprocessedTraceIds().equals(this.getUnprocessedTraceIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTraces() == null ? 0 : this.getTraces().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedTraceIds() == null ? 0 : this.getUnprocessedTraceIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public BatchGetTracesResult clone() {
        try {
            return (BatchGetTracesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

