/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.Throttler;
import com.amazonaws.services.simpleworkflow.model.DomainAlreadyExistsException;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GenericWorker
implements WorkerBase {
    private static final Log log = LogFactory.getLog(GenericWorker.class);
    protected static final int MAX_IDENTITY_LENGTH = 256;
    protected AmazonSimpleWorkflow service;
    protected String domain;
    protected boolean registerDomain;
    protected long domainRetentionPeriodInDays = -1L;
    private String taskListToPoll;
    private int maximumPollRateIntervalMilliseconds = 1000;
    private double maximumPollRatePerSecond;
    private double pollBackoffCoefficient = 2.0;
    private long pollBackoffInitialInterval = 100L;
    private long pollBackoffMaximumInterval = 60000L;
    private boolean disableTypeRegitrationOnStart;
    private boolean disableServiceShutdownOnStop;
    private ThreadPoolExecutor pollExecutor;
    private String identity = ManagementFactory.getRuntimeMXBean().getName();
    protected final AtomicReference<CountDownLatch> suspendLatch = new AtomicReference();
    private int pollThreadCount = 1;
    private BackoffThrottler pollBackoffThrottler;
    private Throttler pollRateThrottler;
    protected Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error((Object)("Failure in thread " + t.getName()), e);
        }
    };
    private TaskPoller poller;

    public GenericWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
    }

    public GenericWorker() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        int length = Math.min(this.identity.length(), 256);
        this.identity = this.identity.substring(0, length);
    }

    @Override
    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.service = service;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean isRegisterDomain() {
        return this.registerDomain;
    }

    @Override
    public void setRegisterDomain(boolean registerDomain) {
        this.registerDomain = registerDomain;
    }

    @Override
    public long getDomainRetentionPeriodInDays() {
        return this.domainRetentionPeriodInDays;
    }

    @Override
    public void setDomainRetentionPeriodInDays(long domainRetentionPeriodInDays) {
        this.domainRetentionPeriodInDays = domainRetentionPeriodInDays;
    }

    @Override
    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String taskListToPoll) {
        this.taskListToPoll = taskListToPoll;
    }

    @Override
    public double getMaximumPollRatePerSecond() {
        return this.maximumPollRatePerSecond;
    }

    @Override
    public void setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
        this.maximumPollRatePerSecond = maximumPollRatePerSecond;
    }

    @Override
    public int getMaximumPollRateIntervalMilliseconds() {
        return this.maximumPollRateIntervalMilliseconds;
    }

    @Override
    public void setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
        this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public long getPollBackoffInitialInterval() {
        return this.pollBackoffInitialInterval;
    }

    @Override
    public void setPollBackoffInitialInterval(long backoffInitialInterval) {
        if (backoffInitialInterval < 0L) {
            throw new IllegalArgumentException("expected value should be positive or 0: " + backoffInitialInterval);
        }
        this.pollBackoffInitialInterval = backoffInitialInterval;
    }

    @Override
    public long getPollBackoffMaximumInterval() {
        return this.pollBackoffMaximumInterval;
    }

    @Override
    public void setPollBackoffMaximumInterval(long backoffMaximumInterval) {
        if (backoffMaximumInterval <= 0L) {
            throw new IllegalArgumentException("expected value should be positive: " + backoffMaximumInterval);
        }
        this.pollBackoffMaximumInterval = backoffMaximumInterval;
    }

    @Override
    public boolean isDisableServiceShutdownOnStop() {
        return this.disableServiceShutdownOnStop;
    }

    @Override
    public void setDisableServiceShutdownOnStop(boolean disableServiceShutdownOnStop) {
        this.disableServiceShutdownOnStop = disableServiceShutdownOnStop;
    }

    @Override
    public double getPollBackoffCoefficient() {
        return this.pollBackoffCoefficient;
    }

    @Override
    public void setPollBackoffCoefficient(double backoffCoefficient) {
        if (backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("expected value should be bigger or equal to 1.0: " + backoffCoefficient);
        }
        this.pollBackoffCoefficient = backoffCoefficient;
    }

    @Override
    public int getPollThreadCount() {
        return this.pollThreadCount;
    }

    @Override
    public void setPollThreadCount(int threadCount) {
        this.checkStarted();
        this.pollThreadCount = threadCount;
    }

    @Override
    public void setDisableTypeRegistrationOnStart(boolean disableTypeRegistrationOnStart) {
        this.disableTypeRegitrationOnStart = disableTypeRegistrationOnStart;
    }

    @Override
    public boolean isDisableTypeRegistrationOnStart() {
        return this.disableTypeRegitrationOnStart;
    }

    @Override
    public void start() {
        if (log.isInfoEnabled()) {
            log.info((Object)("start: " + this.toString()));
        }
        this.checkStarted();
        this.checkRequiredProperty(this.service, "service");
        this.checkRequiredProperty(this.domain, "domain");
        this.checkRequiredProperty(this.taskListToPoll, "taskListToPoll");
        this.checkRequredProperties();
        if (this.registerDomain) {
            this.registerDomain();
        }
        if (!this.disableTypeRegitrationOnStart) {
            this.registerTypesToPoll();
        }
        if (this.maximumPollRatePerSecond > 0.0) {
            this.pollRateThrottler = new Throttler("pollRateThrottler " + this.taskListToPoll, this.maximumPollRatePerSecond, this.maximumPollRateIntervalMilliseconds);
        }
        this.pollExecutor = new ThreadPoolExecutor(this.pollThreadCount, this.pollThreadCount, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.pollThreadCount));
        ExecutorThreadFactory pollExecutorThreadFactory = this.getExecutorThreadFactory();
        this.pollExecutor.setThreadFactory(pollExecutorThreadFactory);
        this.pollBackoffThrottler = new BackoffThrottler(this.pollBackoffInitialInterval, this.pollBackoffMaximumInterval, this.pollBackoffCoefficient);
        this.poller = this.createPoller();
        int i = 0;
        while (i < this.pollThreadCount) {
            this.pollExecutor.execute(new PollServiceTask(this.poller));
            ++i;
        }
    }

    private ExecutorThreadFactory getExecutorThreadFactory() {
        ExecutorThreadFactory pollExecutorThreadFactory = new ExecutorThreadFactory(this.getPollThreadNamePrefix());
        return pollExecutorThreadFactory;
    }

    protected abstract String getPollThreadNamePrefix();

    protected abstract TaskPoller createPoller();

    protected abstract void checkRequredProperties();

    private void registerDomain() {
        block3: {
            if (this.domainRetentionPeriodInDays == -1L) {
                throw new IllegalStateException("required property domainRetentionPeriodInSeconds is not set");
            }
            try {
                this.service.registerDomain(new RegisterDomainRequest().withName(this.domain).withWorkflowExecutionRetentionPeriodInDays(String.valueOf(this.domainRetentionPeriodInDays)));
            }
            catch (DomainAlreadyExistsException domainAlreadyExistsException) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Domain is already registered: " + this.domain));
            }
        }
    }

    protected void checkRequiredProperty(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException("required property " + name + " is not set");
        }
    }

    protected void checkStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
    }

    private boolean isStarted() {
        return this.pollExecutor != null;
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"shutdown");
        }
        if (!this.isStarted()) {
            return;
        }
        if (!this.disableServiceShutdownOnStop) {
            this.service.shutdown();
        }
        this.pollExecutor.shutdown();
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info((Object)"shutdownNow");
        }
        if (!this.isStarted()) {
            return;
        }
        if (!this.disableServiceShutdownOnStop) {
            this.service.shutdown();
        }
        this.pollExecutor.shutdownNow();
        this.poller.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean terminated = this.pollExecutor.awaitTermination(timeout, unit);
        long elapsed = System.currentTimeMillis() - start;
        long left = TimeUnit.MILLISECONDS.convert(timeout, unit) - elapsed;
        return this.poller.awaitTermination(left, TimeUnit.MILLISECONDS) && terminated;
    }

    @Override
    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.isStarted()) {
            return true;
        }
        long start = System.currentTimeMillis();
        if (!this.disableServiceShutdownOnStop) {
            this.service.shutdown();
        }
        this.pollExecutor.shutdownNow();
        try {
            this.pollExecutor.awaitTermination(timeout, unit);
        }
        finally {
            this.poller.shutdown();
        }
        long elapsed = System.currentTimeMillis() - start;
        long left = TimeUnit.MILLISECONDS.convert(timeout, unit) - elapsed;
        return this.awaitTermination(left, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[service=" + this.service + ", domain=" + this.domain + ", taskListToPoll=" + this.taskListToPoll + ", identity=" + this.identity + ", backoffInitialInterval=" + this.pollBackoffInitialInterval + ", backoffMaximumInterval=" + this.pollBackoffMaximumInterval + ", backoffCoefficient=" + this.pollBackoffCoefficient + "]";
    }

    @Override
    public boolean isRunning() {
        return this.isStarted() && !this.pollExecutor.isTerminated();
    }

    @Override
    public void suspendPolling() {
        if (log.isInfoEnabled()) {
            log.info((Object)"suspendPolling");
        }
        this.suspendLatch.set(new CountDownLatch(1));
    }

    @Override
    public void resumePolling() {
        CountDownLatch existing;
        if (log.isInfoEnabled()) {
            log.info((Object)"resumePolling");
        }
        if ((existing = (CountDownLatch)this.suspendLatch.getAndSet(null)) != null) {
            existing.countDown();
        }
    }

    class ExecutorThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadIndex = new AtomicInteger();
        private final String threadPrefix;

        public ExecutorThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setName(String.valueOf(this.threadPrefix) + this.threadIndex.incrementAndGet());
            result.setUncaughtExceptionHandler(GenericWorker.this.uncaughtExceptionHandler);
            return result;
        }
    }

    private class PollServiceTask
    implements Runnable {
        private final TaskPoller poller;

        PollServiceTask(TaskPoller poller) {
            this.poller = poller;
        }

        @Override
        public void run() {
            try {
                CountDownLatch suspender;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"poll task begin");
                }
                if (GenericWorker.this.pollExecutor.isTerminating()) {
                    return;
                }
                GenericWorker.this.pollBackoffThrottler.throttle();
                if (GenericWorker.this.pollExecutor.isTerminating()) {
                    return;
                }
                if (GenericWorker.this.pollRateThrottler != null) {
                    GenericWorker.this.pollRateThrottler.throttle();
                }
                if ((suspender = GenericWorker.this.suspendLatch.get()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("poll task suspending latchCount=" + suspender.getCount()));
                    }
                    suspender.await();
                }
                if (GenericWorker.this.pollExecutor.isTerminating()) {
                    return;
                }
                try {
                    this.poller.pollAndProcessSingleTask();
                    GenericWorker.this.pollBackoffThrottler.success();
                }
                catch (Throwable e) {
                    GenericWorker.this.pollBackoffThrottler.failure();
                    if (!(e.getCause() instanceof InterruptedException)) {
                        GenericWorker.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                if (!GenericWorker.this.pollExecutor.isShutdown()) {
                    GenericWorker.this.pollExecutor.execute(this);
                }
            }
        }
    }
}

