/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListAliasesRequestMarshaller
implements Marshaller<Request<ListAliasesRequest>, ListAliasesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAliasesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAliasesRequest> marshall(ListAliasesRequest listAliasesRequest) {
        if (listAliasesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAliasesRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", listAliasesRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        if (listAliasesRequest.getFunctionVersion() != null) {
            request.addParameter("FunctionVersion", StringUtils.fromString((String)listAliasesRequest.getFunctionVersion()));
        }
        if (listAliasesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listAliasesRequest.getMarker()));
        }
        if (listAliasesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listAliasesRequest.getMaxItems()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

