/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;

public class InvokeAsyncRequestMarshaller
implements Marshaller<Request<InvokeAsyncRequest>, InvokeAsyncRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public InvokeAsyncRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InvokeAsyncRequest> marshall(InvokeAsyncRequest invokeAsyncRequest) {
        if (invokeAsyncRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)invokeAsyncRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2014-11-13/functions/{FunctionName}/invoke-async/";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", invokeAsyncRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        request.setContent(invokeAsyncRequest.getInvokeArgs());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

