/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Sunglasses;

public class SunglassesJsonMarshaller {
    private static SunglassesJsonMarshaller instance;

    public void marshall(Sunglasses sunglasses, StructuredJsonGenerator jsonGenerator) {
        if (sunglasses == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (sunglasses.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(sunglasses.getValue().booleanValue());
            }
            if (sunglasses.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(sunglasses.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SunglassesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SunglassesJsonMarshaller();
        }
        return instance;
    }
}

