/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.S3Object;

public class S3ObjectJsonMarshaller {
    private static S3ObjectJsonMarshaller instance;

    public void marshall(S3Object s3Object, StructuredJsonGenerator jsonGenerator) {
        if (s3Object == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3Object.getBucket() != null) {
                jsonGenerator.writeFieldName("Bucket").writeValue(s3Object.getBucket());
            }
            if (s3Object.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(s3Object.getName());
            }
            if (s3Object.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(s3Object.getVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3ObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectJsonMarshaller();
        }
        return instance;
    }
}

