/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Label;

public class LabelJsonMarshaller {
    private static LabelJsonMarshaller instance;

    public void marshall(Label label, StructuredJsonGenerator jsonGenerator) {
        if (label == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (label.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(label.getName());
            }
            if (label.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(label.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LabelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LabelJsonMarshaller();
        }
        return instance;
    }
}

