/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.S3Resource;
import com.amazonaws.services.snowball.model.transform.KeyRangeJsonMarshaller;

public class S3ResourceJsonMarshaller {
    private static S3ResourceJsonMarshaller instance;

    public void marshall(S3Resource s3Resource, StructuredJsonGenerator jsonGenerator) {
        if (s3Resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3Resource.getBucketArn() != null) {
                jsonGenerator.writeFieldName("BucketArn").writeValue(s3Resource.getBucketArn());
            }
            if (s3Resource.getKeyRange() != null) {
                jsonGenerator.writeFieldName("KeyRange");
                KeyRangeJsonMarshaller.getInstance().marshall(s3Resource.getKeyRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3ResourceJsonMarshaller();
        }
        return instance;
    }
}

