/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;

public class StreamSpecificationJsonMarshaller {
    private static StreamSpecificationJsonMarshaller instance;

    public void marshall(StreamSpecification streamSpecification, StructuredJsonGenerator jsonGenerator) {
        if (streamSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (streamSpecification.getStreamEnabled() != null) {
                jsonGenerator.writeFieldName("StreamEnabled").writeValue(streamSpecification.getStreamEnabled().booleanValue());
            }
            if (streamSpecification.getStreamViewType() != null) {
                jsonGenerator.writeFieldName("StreamViewType").writeValue(streamSpecification.getStreamViewType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamSpecificationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamSpecificationJsonMarshaller();
        }
        return instance;
    }
}

