/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeysAndAttributes
implements Serializable,
Cloneable {
    private List<Map<String, AttributeValue>> keys;
    private List<String> attributesToGet;
    private Boolean consistentRead;
    private String projectionExpression;
    private Map<String, String> expressionAttributeNames;

    public List<Map<String, AttributeValue>> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<Map<String, AttributeValue>> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<Map<String, AttributeValue>>(keys);
    }

    public KeysAndAttributes withKeys(Map<String, AttributeValue> ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<Map<String, AttributeValue>>(keys.length));
        }
        for (Map<String, AttributeValue> ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public KeysAndAttributes withKeys(Collection<Map<String, AttributeValue>> keys) {
        this.setKeys(keys);
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        this.attributesToGet = new ArrayList<String>(attributesToGet);
    }

    public KeysAndAttributes withAttributesToGet(String ... attributesToGet) {
        if (this.attributesToGet == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String ele : attributesToGet) {
            this.attributesToGet.add(ele);
        }
        return this;
    }

    public KeysAndAttributes withAttributesToGet(Collection<String> attributesToGet) {
        this.setAttributesToGet(attributesToGet);
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public KeysAndAttributes withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public KeysAndAttributes withProjectionExpression(String projectionExpression) {
        this.setProjectionExpression(projectionExpression);
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public KeysAndAttributes withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public KeysAndAttributes addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public KeysAndAttributes clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.getAttributesToGet()).append(",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.getConsistentRead()).append(",");
        }
        if (this.getProjectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.getProjectionExpression()).append(",");
        }
        if (this.getExpressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.getExpressionAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeysAndAttributes)) {
            return false;
        }
        KeysAndAttributes other = (KeysAndAttributes)obj;
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !other.getAttributesToGet().equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        if (other.getConsistentRead() != null && !other.getConsistentRead().equals(this.getConsistentRead())) {
            return false;
        }
        if (other.getProjectionExpression() == null ^ this.getProjectionExpression() == null) {
            return false;
        }
        if (other.getProjectionExpression() != null && !other.getProjectionExpression().equals(this.getProjectionExpression())) {
            return false;
        }
        if (other.getExpressionAttributeNames() == null ^ this.getExpressionAttributeNames() == null) {
            return false;
        }
        return other.getExpressionAttributeNames() == null || other.getExpressionAttributeNames().equals(this.getExpressionAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : this.getAttributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        hashCode = 31 * hashCode + (this.getProjectionExpression() == null ? 0 : this.getProjectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeNames() == null ? 0 : this.getExpressionAttributeNames().hashCode());
        return hashCode;
    }

    public KeysAndAttributes clone() {
        try {
            return (KeysAndAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

