/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryClientServiceFactory;
import org.apache.knox.gateway.services.AbstractGatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.impl.CLIMasterService;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;
import org.apache.knox.gateway.services.security.impl.DefaultCryptoService;
import org.apache.knox.gateway.services.security.impl.DefaultKeystoreService;
import org.apache.knox.gateway.services.security.impl.RemoteAliasService;
import org.apache.knox.gateway.services.topology.impl.DefaultTopologyService;
import org.apache.knox.gateway.topology.Provider;

public class CLIGatewayServices
extends AbstractGatewayServices {
    public CLIGatewayServices() {
        super("Services", "GatewayServices");
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        CLIMasterService ms = new CLIMasterService();
        ms.init(config, options);
        this.addService(ServiceType.MASTER_SERVICE, ms);
        DefaultKeystoreService ks = new DefaultKeystoreService();
        ks.setMasterService(ms);
        ks.init(config, options);
        this.addService(ServiceType.KEYSTORE_SERVICE, ks);
        DefaultAliasService defaultAlias = new DefaultAliasService();
        defaultAlias.setKeystoreService(ks);
        defaultAlias.setMasterService(ms);
        defaultAlias.init(config, options);
        RemoteConfigurationRegistryClientService registryClientService = RemoteConfigurationRegistryClientServiceFactory.newInstance((GatewayConfig)config);
        registryClientService.setAliasService((AliasService)defaultAlias);
        registryClientService.init(config, options);
        this.addService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE, (Service)registryClientService);
        RemoteAliasService alias = new RemoteAliasService(defaultAlias, ms);
        alias.init(config, options);
        this.addService(ServiceType.ALIAS_SERVICE, (Service)alias);
        DefaultCryptoService crypto = new DefaultCryptoService();
        crypto.setKeystoreService(ks);
        crypto.setAliasService(alias);
        crypto.init(config, options);
        this.addService(ServiceType.CRYPTO_SERVICE, (Service)crypto);
        DefaultTopologyService tops = new DefaultTopologyService();
        tops.init(config, options);
        this.addService(ServiceType.TOPOLOGY_SERVICE, (Service)tops);
    }

    public void initializeContribution(DeploymentContext context) {
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, org.apache.knox.gateway.topology.Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }

    public void finalizeContribution(DeploymentContext context) {
    }
}

