/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.yarn;

import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.yarn.ResourceManagerServiceModelGeneratorBase;

public class YarnUIServiceModelGenerator
extends ResourceManagerServiceModelGeneratorBase {
    private static final String SERVICE = "YARNUI";
    static final String RM_HTTPS_PORT = "resourcemanager_webserver_https_port";
    static final String RM_HTTP_PORT = "resourcemanager_webserver_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        ServiceModel model = this.createServiceModel(this.generateURL(service, serviceConfig, role, roleConfig));
        model.addRoleProperty(this.getRoleType(), RM_HTTP_PORT, this.getRoleConfigValue(roleConfig, RM_HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), RM_HTTPS_PORT, this.getRoleConfigValue(roleConfig, RM_HTTPS_PORT));
        return model;
    }

    protected String generateURL(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        if (this.isSSLEnabled(service, serviceConfig)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, RM_HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, RM_HTTP_PORT);
        }
        return String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port);
    }

    private boolean isSSLEnabled(ApiService service, ApiServiceConfig serviceConfig) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi(this.getClient());
        String clusterName = service.getClusterRef().getClusterName();
        String hdfsService = this.getServiceConfigValue(serviceConfig, "hdfs_service");
        ApiServiceConfig hdfsServiceConfig = servicesResourceApi.readServiceConfig(clusterName, hdfsService, "full");
        return Boolean.parseBoolean(this.getServiceConfigValue(hdfsServiceConfig, "hdfs_hadoop_ssl_enabled"));
    }
}

