/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.HashMap;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.hibernate.jpa.event.spi.jpa.Callback;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;

public class CallbackRegistryImpl
implements CallbackRegistry {
    private HashMap<Class, Callback[]> preCreates = new HashMap();
    private HashMap<Class, Callback[]> postCreates = new HashMap();
    private HashMap<Class, Callback[]> preRemoves = new HashMap();
    private HashMap<Class, Callback[]> postRemoves = new HashMap();
    private HashMap<Class, Callback[]> preUpdates = new HashMap();
    private HashMap<Class, Callback[]> postUpdates = new HashMap();
    private HashMap<Class, Callback[]> postLoads = new HashMap();

    @Override
    public void preCreate(Object bean) {
        this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    @Override
    public boolean hasPostCreateCallbacks(Class entityClass) {
        return this.notEmpty(this.preCreates.get(entityClass));
    }

    private boolean notEmpty(Callback[] callbacks) {
        return callbacks != null && callbacks.length > 0;
    }

    @Override
    public void postCreate(Object bean) {
        this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    @Override
    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    @Override
    public boolean hasPostUpdateCallbacks(Class entityClass) {
        return this.notEmpty(this.postUpdates.get(entityClass));
    }

    @Override
    public void postUpdate(Object bean) {
        this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void preRemove(Object bean) {
        this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    @Override
    public boolean hasPostRemoveCallbacks(Class entityClass) {
        return this.notEmpty(this.postRemoves.get(entityClass));
    }

    @Override
    public void postRemove(Object bean) {
        this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    @Override
    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    private boolean callback(Callback[] callbacks, Object bean) {
        if (callbacks != null && callbacks.length != 0) {
            for (Callback callback : callbacks) {
                callback.performCallback(bean);
            }
            return true;
        }
        return false;
    }

    public void addEntityCallbacks(Class entityClass, Class annotationClass, Callback[] callbacks) {
        HashMap<Class, Callback[]> map = this.determineAppropriateCallbackMap(annotationClass);
        if (map.containsKey(entityClass)) {
            throw new PersistenceException("Error build callback listeners; entity [" + entityClass.getName() + " was already processed");
        }
        map.put(entityClass, callbacks);
    }

    private HashMap<Class, Callback[]> determineAppropriateCallbackMap(Class annotationClass) {
        if (PrePersist.class.equals((Object)annotationClass)) {
            return this.preCreates;
        }
        if (PostPersist.class.equals((Object)annotationClass)) {
            return this.postCreates;
        }
        if (PreRemove.class.equals((Object)annotationClass)) {
            return this.preRemoves;
        }
        if (PostRemove.class.equals((Object)annotationClass)) {
            return this.postRemoves;
        }
        if (PreUpdate.class.equals((Object)annotationClass)) {
            return this.preUpdates;
        }
        if (PostUpdate.class.equals((Object)annotationClass)) {
            return this.postUpdates;
        }
        if (PostLoad.class.equals((Object)annotationClass)) {
            return this.postLoads;
        }
        throw new PersistenceException("Unrecognized JPA callback annotation [" + annotationClass.getName() + "]");
    }

    public void release() {
        this.preCreates.clear();
        this.postCreates.clear();
        this.preRemoves.clear();
        this.postRemoves.clear();
        this.preUpdates.clear();
        this.postUpdates.clear();
        this.postLoads.clear();
    }
}

