/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;
import org.apache.knox.gateway.util.PasswordUtils;

public class ZookeeperRemoteAliasService
implements AliasService {
    public static final String TYPE = "zookeeper";
    public static final String PATH_KNOX = "/knox";
    public static final String PATH_KNOX_SECURITY = "/knox/security";
    public static final String PATH_KNOX_ALIAS_STORE_TOPOLOGY = "/knox/security/topology";
    public static final String PATH_SEPARATOR = "/";
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final RemoteConfigurationRegistryClient.EntryACL AUTHENTICATED_USERS_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "";
        }

        public String getType() {
            return "auth";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private static final RemoteConfigurationRegistryClient.EntryACL KERBEROS_KNOX_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "knox";
        }

        public String getType() {
            return "sasl";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private final AliasService localAliasService;
    private final MasterService ms;
    private final RemoteConfigurationRegistryClientService remoteConfigurationRegistryClientService;
    private RemoteConfigurationRegistryClient remoteClient;
    private ConfigurableEncryptor encryptor;
    private GatewayConfig config;

    ZookeeperRemoteAliasService(AliasService localAliasService, MasterService ms, RemoteConfigurationRegistryClientService remoteConfigurationRegistryClientService) {
        this.localAliasService = localAliasService;
        this.ms = ms;
        this.remoteConfigurationRegistryClientService = remoteConfigurationRegistryClientService;
    }

    private static String buildAliasEntryName(String clusterName, String alias) {
        return ZookeeperRemoteAliasService.buildClusterEntryName(clusterName) + PATH_SEPARATOR + alias.toLowerCase(Locale.ROOT);
    }

    private static String buildClusterEntryName(String clusterName) {
        return "/knox/security/topology/" + clusterName;
    }

    private static void ensureEntry(String path, RemoteConfigurationRegistryClient remoteClient) {
        if (!remoteClient.entryExists(path)) {
            remoteClient.createEntry(path);
        } else {
            List entryACLs = remoteClient.getACL(path);
            for (RemoteConfigurationRegistryClient.EntryACL entryACL : entryACLs) {
                if (!"world".equals(entryACL.getType()) || !"anyone".equals(entryACL.getId())) continue;
                LOG.suspectWritableRemoteConfigurationEntry(path);
                if (!remoteClient.isAuthenticationConfigured()) continue;
                LOG.correctingSuspectWritableRemoteConfigurationEntry(path);
                if ("Kerberos".equalsIgnoreCase(remoteClient.authenticationType()) && !remoteClient.isBackwardsCompatible()) {
                    remoteClient.setACL(path, Collections.singletonList(KERBEROS_KNOX_ALL));
                    continue;
                }
                remoteClient.setACL(path, Collections.singletonList(AUTHENTICATED_USERS_ALL));
            }
        }
    }

    private static void checkPathsExist(RemoteConfigurationRegistryClient remoteClient) {
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry("/knox/security/topology/__gateway", remoteClient);
    }

    public List<String> getAliasesForCluster(String clusterName) throws AliasServiceException {
        List localAliases = this.localAliasService.getAliasesForCluster(clusterName);
        if (localAliases == null || localAliases.isEmpty()) {
            return this.remoteClient == null ? new ArrayList<String>() : this.remoteClient.listChildEntries(ZookeeperRemoteAliasService.buildClusterEntryName(clusterName));
        }
        return localAliases;
    }

    public void addAliasForCluster(String clusterName, String alias, String value) throws AliasServiceException {
        if (this.remoteClient != null) {
            String aliasEntryPath = ZookeeperRemoteAliasService.buildAliasEntryName(clusterName, alias);
            ZookeeperRemoteAliasService.checkPathsExist(this.remoteClient);
            ZookeeperRemoteAliasService.ensureEntry(ZookeeperRemoteAliasService.buildClusterEntryName(clusterName), this.remoteClient);
            try {
                this.remoteClient.createEntry(aliasEntryPath, this.encrypt(value));
            }
            catch (Exception e) {
                throw new AliasServiceException(e);
            }
            if (this.remoteClient.getEntryData(aliasEntryPath) == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Failed to store alias %s for cluster %s in remote registry", alias, clusterName));
            }
        }
    }

    public void removeAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        String aliasEntryPath;
        if (this.remoteClient != null && this.remoteClient.entryExists(aliasEntryPath = ZookeeperRemoteAliasService.buildAliasEntryName(clusterName, alias))) {
            this.remoteClient.deleteEntry(aliasEntryPath);
            if (this.remoteClient.entryExists(aliasEntryPath)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Failed to delete alias %s for cluster %s in remote registry", alias, clusterName));
            }
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias, boolean generate) throws AliasServiceException {
        char[] password = this.localAliasService.getPasswordFromAliasForCluster(clusterName, alias);
        if (password == null && this.remoteClient != null) {
            ZookeeperRemoteAliasService.checkPathsExist(this.remoteClient);
            String encrypted = null;
            if (this.remoteClient.entryExists(ZookeeperRemoteAliasService.buildAliasEntryName(clusterName, alias))) {
                encrypted = this.remoteClient.getEntryData(ZookeeperRemoteAliasService.buildAliasEntryName(clusterName, alias));
            }
            if (encrypted == null) {
                if (generate) {
                    this.generateAliasForCluster(clusterName, alias);
                    password = this.getPasswordFromAliasForCluster(clusterName, alias);
                }
            } else {
                try {
                    password = this.decrypt(encrypted).toCharArray();
                }
                catch (Exception e) {
                    throw new AliasServiceException(e);
                }
            }
        }
        return password;
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        String passwordString = PasswordUtils.generatePassword((int)16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeyPassphraseAlias());
    }

    public char[] getGatewayIdentityKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeystorePasswordAlias());
    }

    public char[] getSigningKeyPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeyPassphraseAlias());
    }

    public char[] getSigningKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeystorePasswordAlias());
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) throws AliasServiceException {
        throw new AliasServiceException((Exception)new UnsupportedOperationException());
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        String clientName = config.getRemoteConfigurationMonitorClientName();
        if (clientName != null && this.remoteConfigurationRegistryClientService != null) {
            this.remoteClient = this.remoteConfigurationRegistryClientService.get(clientName);
            this.ensureEntries(this.remoteClient);
            List aliases = this.remoteClient.listChildEntries(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            if (aliases == null) {
                throw new IllegalStateException("Unable to access remote path: /knox/security/topology");
            }
            try {
                this.remoteClient.addChildEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to add listener for path /knox/security/topology", e);
            }
            this.encryptor = new ConfigurableEncryptor(new String(this.ms.getMasterSecret()));
            this.encryptor.init(config);
        } else {
            LOG.missingClientConfigurationForRemoteMonitoring();
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
        if (this.remoteClient != null) {
            try {
                this.remoteClient.removeEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            }
            catch (Exception e) {
                LOG.errorRemovingRemoteListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, e.toString());
            }
        }
    }

    String encrypt(String clear) throws Exception {
        EncryptionResult result = this.encryptor.encrypt(clear);
        return Base64.encodeBase64String((byte[])(Base64.encodeBase64String((byte[])result.salt) + "::" + Base64.encodeBase64String((byte[])result.iv) + "::" + Base64.encodeBase64String((byte[])result.cipher)).getBytes(StandardCharsets.UTF_8));
    }

    String decrypt(String encoded) throws Exception {
        String line = new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8);
        String[] parts = line.split("::");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Data should have 3 parts split by ::");
        }
        return new String(this.encryptor.decrypt(Base64.decodeBase64((String)parts[0]), Base64.decodeBase64((String)parts[1]), Base64.decodeBase64((String)parts[2])), StandardCharsets.UTF_8);
    }

    private void ensureEntries(RemoteConfigurationRegistryClient remoteClient) {
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry("/knox/security/topology/__gateway", remoteClient);
    }

    private class RemoteAliasEntryListener
    implements RemoteConfigurationRegistryClient.EntryListener {
        final String cluster;
        final String alias;
        final AliasService localAliasService;

        RemoteAliasEntryListener(String cluster, String alias, AliasService localAliasService) {
            this.cluster = cluster;
            this.alias = alias;
            this.localAliasService = localAliasService;
        }

        public void entryChanged(RemoteConfigurationRegistryClient client, String path, byte[] data) {
            try {
                this.localAliasService.addAliasForCluster(this.cluster, this.alias, ZookeeperRemoteAliasService.this.decrypt(new String(data, StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                LOG.errorAddingAliasLocally(this.cluster, this.alias, e.toString());
            }
        }
    }

    private class RemoteAliasChildListener
    implements RemoteConfigurationRegistryClient.ChildEntryListener {
        final ZookeeperRemoteAliasService remoteAliasService;

        RemoteAliasChildListener(ZookeeperRemoteAliasService remoteAliasService) {
            this.remoteAliasService = remoteAliasService;
        }

        public void childEvent(RemoteConfigurationRegistryClient client, RemoteConfigurationRegistryClient.ChildEntryListener.Type type, String path) {
            String subPath = StringUtils.substringAfter((String)path, (String)"/knox/security/topology/");
            String[] paths = StringUtils.split((String)subPath, (char)'/');
            switch (type) {
                case REMOVED: {
                    try {
                        client.removeEntryListener(path);
                        if (paths.length <= 1) break;
                        ZookeeperRemoteAliasService.this.localAliasService.removeAliasForCluster(paths[0], paths[1]);
                    }
                    catch (Exception e) {
                        LOG.errorRemovingAliasLocally(paths[0], paths[1], e.toString());
                    }
                    break;
                }
                case ADDED: {
                    if (paths.length > 1) {
                        LOG.addAliasLocally(paths[0], paths[1]);
                        try {
                            client.addEntryListener(path, (RemoteConfigurationRegistryClient.EntryListener)new RemoteAliasEntryListener(paths[0], paths[1], ZookeeperRemoteAliasService.this.localAliasService));
                        }
                        catch (Exception e) {
                            LOG.errorRemovingAliasLocally(paths[0], paths[1], e.toString());
                        }
                        break;
                    }
                    if (subPath == null) break;
                    LOG.addRemoteListener(path);
                    try {
                        client.addChildEntryListener(path, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this.remoteAliasService));
                        break;
                    }
                    catch (Exception e) {
                        LOG.errorAddingRemoteListener(path, e.toString());
                    }
                }
            }
        }
    }
}

