import { ComponentDef, ComponentDefArgs, DirectiveDef, DirectiveDefArgs } from './definition_interfaces';
/**
 * Create a component definition object.
 *
 *
 * # Example
 * ```
 * class MyDirective {
 *   // Generated by Angular Template Compiler
 *   // [Symbol] syntax will not be supported by TypeScript until v2.7
 *   static [COMPONENT_DEF_SYMBOL] = defineComponent({
 *     ...
 *   });
 * }
 * ```
 */
export declare function defineComponent<T>(componentDefinition: ComponentDefArgs<T>): ComponentDef<T>;
export declare function NgOnChangesFeature<T>(definition: DirectiveDef<T>): void;
export declare function PublicFeature<T>(definition: DirectiveDef<T>): void;
/**
 * Create a directive definition object.
 *
 * # Example
 * ```
 * class MyDirective {
 *   // Generated by Angular Template Compiler
 *   // [Symbol] syntax will not be supported by TypeScript until v2.7
 *   static [DIRECTIVE_DEF_SYMBOL] = defineDirective({
 *     ...
 *   });
 * }
 * ```
 */
export declare const defineDirective: <T>(directiveDefinition: DirectiveDefArgs<T>) => DirectiveDef<T>;
