/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ConditionalValueHandler;
import org.apache.knox.gateway.topology.discovery.ambari.PropertyEqualsHandler;
import org.apache.knox.gateway.topology.discovery.ambari.SimpleValueHandler;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceURLPropertyConfig {
    private static final AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private static final String ATTR_NAME = "name";
    private static XPathExpression SERVICE_URL_PATTERN_MAPPINGS;
    private static XPathExpression URL_PATTERN;
    private static XPathExpression PROPERTIES;
    private static final String DEFAULT_SERVICE_URL_MAPPINGS = "ambari-service-discovery-url-mappings.xml";
    private Map<String, URLPattern> urlPatterns = new HashMap<String, URLPattern>();
    private Map<String, Map<String, Property>> properties = new HashMap<String, Map<String, Property>>();

    ServiceURLPropertyConfig() {
        this(ServiceURLPropertyConfig.class.getClassLoader().getResourceAsStream(DEFAULT_SERVICE_URL_MAPPINGS));
    }

    ServiceURLPropertyConfig(File mappingConfigurationFile) throws Exception {
        this(new FileInputStream(mappingConfigurationFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceURLPropertyConfig(InputStream source) {
        try {
            Document doc = XmlUtils.readXml((InputStream)source);
            NodeList serviceNodes = (NodeList)SERVICE_URL_PATTERN_MAPPINGS.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < serviceNodes.getLength(); ++i) {
                NodeList propertiesNode;
                Node serviceNode = serviceNodes.item(i);
                String serviceName = serviceNode.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                this.properties.put(serviceName, new HashMap());
                Node urlPatternNode = (Node)URL_PATTERN.evaluate(serviceNode, XPathConstants.NODE);
                if (urlPatternNode != null) {
                    this.urlPatterns.put(serviceName, new URLPattern(urlPatternNode.getNodeValue()));
                }
                if ((propertiesNode = (NodeList)PROPERTIES.evaluate(serviceNode, XPathConstants.NODESET)) == null) continue;
                this.processProperties(serviceName, propertiesNode);
            }
        }
        catch (Exception e) {
            log.failedToLoadServiceDiscoveryURLDefConfiguration(e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void processProperties(String serviceName, NodeList propertyNodes) {
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Property p = Property.createProperty(serviceName, propertyNodes.item(i));
            this.properties.get(serviceName).put(p.getName(), p);
        }
    }

    URLPattern getURLPattern(String service) {
        return this.urlPatterns.get(service);
    }

    void setAll(ServiceURLPropertyConfig overrides) {
        if (overrides != null) {
            if (overrides.urlPatterns != null) {
                for (String service : overrides.urlPatterns.keySet()) {
                    URLPattern overridePattern = overrides.urlPatterns.get(service);
                    if (this.urlPatterns.containsKey(service)) {
                        this.urlPatterns.replace(service, overridePattern);
                        continue;
                    }
                    this.urlPatterns.put(service, overridePattern);
                }
            }
            for (String service : overrides.properties.keySet()) {
                Map<String, Property> serviceProperties = overrides.properties.get(service);
                if (serviceProperties == null) continue;
                Map<String, Property> existingServiceProps = this.properties.get(service);
                if (existingServiceProps != null) {
                    existingServiceProps.clear();
                }
                for (String propertyName : serviceProperties.keySet()) {
                    this.setConfigProperty(service, propertyName, serviceProperties.get(propertyName));
                }
            }
        }
    }

    void setConfigProperty(String service, String name, Property value) {
        Map<String, Property> serviceProperties = this.properties.get(service);
        if (serviceProperties == null) {
            serviceProperties = new HashMap<String, Property>();
            this.properties.put(service, serviceProperties);
        }
        serviceProperties.put(name, value);
    }

    Property getConfigProperty(String service, String property) {
        Property result = null;
        Map<String, Property> serviceProperties = this.properties.get(service);
        if (serviceProperties != null) {
            result = serviceProperties.get(property);
        }
        return result;
    }

    static {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            SERVICE_URL_PATTERN_MAPPINGS = xpath.compile("/service-discovery-url-mappings/service");
            URL_PATTERN = xpath.compile("url-pattern/text()");
            PROPERTIES = xpath.compile("properties/property");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    static class Property {
        static final String TYPE_SERVICE = "SERVICE";
        static final String TYPE_COMPONENT = "COMPONENT";
        static final String TYPE_DERIVED = "DERIVED";
        static final String PROP_COMP_HOSTNAME = "component.host.name";
        static final String ATTR_NAME = "name";
        static final String ATTR_PROPERTY = "property";
        static final String ATTR_VALUE = "value";
        static XPathExpression HOSTNAME;
        static XPathExpression SERVICE_CONFIG;
        static XPathExpression COMPONENT;
        static XPathExpression CONFIG_PROPERTY;
        static XPathExpression IF;
        static XPathExpression THEN;
        static XPathExpression ELSE;
        static XPathExpression TEXT;
        String type;
        String name;
        String component;
        String service;
        String serviceConfig;
        String value;
        ConditionalValueHandler conditionHandler = null;

        private Property(String type, String propertyName, String component, String service, String configType, String value, ConditionalValueHandler pch) {
            this.type = type;
            this.name = propertyName;
            this.service = service;
            this.component = component;
            this.serviceConfig = configType;
            this.value = value;
            this.conditionHandler = pch;
        }

        static Property createProperty(String serviceName, Node propertyNode) {
            String propertyName = propertyNode.getAttributes().getNamedItem("name").getNodeValue();
            String propertyType = null;
            String serviceType = null;
            String configType = null;
            String componentType = null;
            String value = null;
            ConditionalValueHandler pch = null;
            try {
                Node scNode;
                Node hostNameNode = (Node)HOSTNAME.evaluate(propertyNode, XPathConstants.NODE);
                if (hostNameNode != null) {
                    value = PROP_COMP_HOSTNAME;
                }
                if ((scNode = (Node)SERVICE_CONFIG.evaluate(propertyNode, XPathConstants.NODE)) != null) {
                    propertyType = TYPE_SERVICE;
                    serviceType = scNode.getAttributes().getNamedItem("name").getNodeValue();
                    Node scTextNode = (Node)TEXT.evaluate(scNode, XPathConstants.NODE);
                    configType = scTextNode.getNodeValue();
                } else {
                    Node cNode = (Node)COMPONENT.evaluate(propertyNode, XPathConstants.NODE);
                    if (cNode != null) {
                        propertyType = TYPE_COMPONENT;
                        componentType = cNode.getFirstChild().getNodeValue();
                        Node cTextNode = (Node)TEXT.evaluate(cNode, XPathConstants.NODE);
                        configType = cTextNode.getNodeValue();
                        componentType = cTextNode.getNodeValue();
                    }
                }
                Node cpNode = (Node)CONFIG_PROPERTY.evaluate(propertyNode, XPathConstants.NODE);
                if (cpNode != null) {
                    Node ifNode = (Node)IF.evaluate(cpNode, XPathConstants.NODE);
                    if (ifNode != null) {
                        propertyType = TYPE_DERIVED;
                        pch = Property.getConditionHandler(serviceName, ifNode);
                    } else {
                        Node cpTextNode = (Node)TEXT.evaluate(cpNode, XPathConstants.NODE);
                        value = cpTextNode.getNodeValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new Property(propertyType, propertyName, componentType, serviceType, configType, value, pch);
        }

        private static ConditionalValueHandler getConditionHandler(String serviceName, Node ifNode) throws Exception {
            PropertyEqualsHandler result = null;
            if (ifNode != null) {
                NamedNodeMap attrs = ifNode.getAttributes();
                String comparisonPropName = attrs.getNamedItem(ATTR_PROPERTY).getNodeValue();
                String comparisonValue = null;
                Node valueNode = attrs.getNamedItem(ATTR_VALUE);
                if (valueNode != null) {
                    comparisonValue = attrs.getNamedItem(ATTR_VALUE).getNodeValue();
                }
                ConditionalValueHandler affirmativeResult = null;
                Node thenNode = (Node)THEN.evaluate(ifNode, XPathConstants.NODE);
                if (thenNode != null) {
                    Node subIfNode = (Node)IF.evaluate(thenNode, XPathConstants.NODE);
                    affirmativeResult = subIfNode != null ? Property.getConditionHandler(serviceName, subIfNode) : new SimpleValueHandler(thenNode.getFirstChild().getNodeValue());
                }
                ConditionalValueHandler negativeResult = null;
                Node elseNode = (Node)ELSE.evaluate(ifNode, XPathConstants.NODE);
                if (elseNode != null) {
                    Node subIfNode = (Node)IF.evaluate(elseNode, XPathConstants.NODE);
                    negativeResult = subIfNode != null ? Property.getConditionHandler(serviceName, subIfNode) : new SimpleValueHandler(elseNode.getFirstChild().getNodeValue());
                }
                result = new PropertyEqualsHandler(serviceName, comparisonPropName, comparisonValue, affirmativeResult, negativeResult);
            }
            return result;
        }

        String getType() {
            return this.type;
        }

        String getName() {
            return this.name;
        }

        String getComponent() {
            return this.component;
        }

        String getService() {
            return this.service;
        }

        String getServiceConfig() {
            return this.serviceConfig;
        }

        String getValue() {
            return this.value;
        }

        ConditionalValueHandler getConditionHandler() {
            return this.conditionHandler;
        }

        static {
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                HOSTNAME = xpath.compile("hostname");
                SERVICE_CONFIG = xpath.compile("service-config");
                COMPONENT = xpath.compile("component");
                CONFIG_PROPERTY = xpath.compile("config-property");
                IF = xpath.compile("if");
                THEN = xpath.compile("then");
                ELSE = xpath.compile("else");
                TEXT = xpath.compile("text()");
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }

    static class URLPattern {
        String pattern;
        List<String> placeholders = new ArrayList<String>();

        URLPattern(String pattern) {
            this.pattern = pattern;
            Pattern regex = Pattern.compile("\\{(.*?)}", 32);
            Matcher matcher = regex.matcher(pattern);
            while (matcher.find()) {
                this.placeholders.add(matcher.group(1));
            }
        }

        String get() {
            return this.pattern;
        }

        List<String> getPlaceholders() {
            return this.placeholders;
        }
    }
}

