/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAssertionValueFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAssertionValueFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAssertionValueFilter() {
        super("Initialize Assertion Value filter");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        AttributeValueAssertion assertion = terminalFilter.getAssertion();
        if (container.isBinary(assertion.getAttributeDesc())) {
            BinaryValue assertionValue = tlv.getLength() != 0 ? new BinaryValue(tlv.getValue().getData()) : new BinaryValue(Strings.EMPTY_BYTES);
            assertion.setAssertionValue(assertionValue);
        } else {
            StringValue assertionValue = tlv.getLength() != 0 ? new StringValue(Strings.utf8ToString(tlv.getValue().getData())) : new StringValue("");
            assertion.setAssertionValue(assertionValue);
        }
        searchRequestDecorator.unstackFilters(container);
        if (IS_DEBUG) {
            LOG.debug("Initialize Assertion Value filter");
        }
    }
}

