/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <mathmlMo.hxx>

static moOperatorData moOperatorDataDictionaryData[starmathdatabase::MATHML_MO_COUNT]
    = { { u"\u2018"_ustr, moOpDF::prefix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u2019"_ustr, moOpDF::postfix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u201C"_ustr, moOpDF::prefix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"\u201D"_ustr, moOpDF::postfix, 10, 0, 0, moOpDP::fence | moOpDP::nonedp },
        { u"("_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u")"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"["_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"]"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"{"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|"_ustr, moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"||"_ustr, moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|||"_ustr, moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"}"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2016"_ustr, moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence },
        { u"\u2308"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2309"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u230A"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u230B"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2329"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u232A"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2772"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2773"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E6"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E7"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E8"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27E9"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EA"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EB"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EC"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27ED"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EE"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u27EF"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2980"_ustr, moOpDF::prepostfix, 20, 0, 0, moOpDP::stretchyfence },
        { u"\u2983"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2984"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2985"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2986"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2987"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2988"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2989"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298A"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298B"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298C"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298D"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298E"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u298F"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2990"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2991"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2992"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2993"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2994"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2995"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2996"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2997"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2998"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u29FC"_ustr, moOpDF::prefix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u29FD"_ustr, moOpDF::postfix, 20, 0, 0, moOpDP::stretchyfence | moOpDP::symmetric },
        { u";"_ustr, moOpDF::infix, 30, 0, 3, moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u","_ustr, moOpDF::infix, 40, 0, 3, moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u"\u2063"_ustr, moOpDF::infix, 40, 0, 0,
          moOpDP::separator | moOpDP::linebreakstyleAfter },
        { u"\u2234"_ustr, moOpDF::infix, 70, 5, 5, moOpDP::nonedp },
        { u"\u2235"_ustr, moOpDF::infix, 70, 5, 5, moOpDP::nonedp },
        { u"->"_ustr, moOpDF::infix, 90, 5, 5, moOpDP::nonedp },
        { u".."_ustr, moOpDF::postfix, 100, 0, 0, moOpDP::nonedp },
        { u"..."_ustr, moOpDF::postfix, 100, 0, 0, moOpDP::nonedp },
        { u":"_ustr, moOpDF::infix, 100, 1, 2, moOpDP::nonedp },
        { u"\u03F6"_ustr, moOpDF::infix, 110, 5, 5, moOpDP::nonedp },
        { u"\u2026"_ustr, moOpDF::infix, 150, 0, 0, moOpDP::nonedp },
        { u"\u22EE"_ustr, moOpDF::infix, 150, 5, 5, moOpDP::nonedp },
        { u"\u22EF"_ustr, moOpDF::infix, 150, 0, 0, moOpDP::nonedp },
        { u"\u22F1"_ustr, moOpDF::infix, 150, 5, 5, moOpDP::nonedp },
        { u"\u220B"_ustr, moOpDF::infix, 160, 5, 5, moOpDP::nonedp },
        { u"\u22A2"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A3"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A4"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A8"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22A9"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AC"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AD"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AE"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u22AF"_ustr, moOpDF::infix, 170, 5, 5, moOpDP::nonedp },
        { u"\u2228"_ustr, moOpDF::infix, 190, 4, 4, moOpDP::nonedp },
        { u"&&"_ustr, moOpDF::infix, 200, 4, 4, moOpDP::nonedp },
        { u"\u2227"_ustr, moOpDF::infix, 200, 4, 4, moOpDP::nonedp },
        { u"\u2200"_ustr, moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2203"_ustr, moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2204"_ustr, moOpDF::prefix, 230, 2, 1, moOpDP::nonedp },
        { u"\u2201"_ustr, moOpDF::infix, 240, 1, 2, moOpDP::nonedp },
        { u"\u2208"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2209"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u220C"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2282"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2282\u20D2"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2283"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2283\u20D2"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2284"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2285"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2286"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2287"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2288"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u2289"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u228A"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"\u228B"_ustr, moOpDF::infix, 240, 5, 5, moOpDP::nonedp },
        { u"<="_ustr, moOpDF::infix, 241, 5, 5, moOpDP::nonedp },
        { u"\u2264"_ustr, moOpDF::infix, 241, 5, 5, moOpDP::nonedp },
        { u"\u2265"_ustr, moOpDF::infix, 242, 5, 5, moOpDP::nonedp },
        { u">"_ustr, moOpDF::infix, 243, 5, 5, moOpDP::nonedp },
        { u">="_ustr, moOpDF::infix, 243, 5, 5, moOpDP::nonedp },
        { u"\u226F"_ustr, moOpDF::infix, 244, 5, 5, moOpDP::nonedp },
        { u"&lt"_ustr, moOpDF::infix, 245, 5, 5, moOpDP::nonedp },
        { u"\u226E"_ustr, moOpDF::infix, 246, 5, 5, moOpDP::nonedp },
        { u"\u2248"_ustr, moOpDF::infix, 247, 5, 5, moOpDP::nonedp },
        { u"\u223C"_ustr, moOpDF::infix, 250, 5, 5, moOpDP::nonedp },
        { u"\u2249"_ustr, moOpDF::infix, 250, 5, 5, moOpDP::nonedp },
        { u"\u2262"_ustr, moOpDF::infix, 252, 5, 5, moOpDP::nonedp },
        { u"\u2260"_ustr, moOpDF::infix, 255, 5, 5, moOpDP::nonedp },
        { u"!="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"*="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"+="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"-="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"/="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u":="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"="_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"=="_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u221D"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2224"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2225"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2226"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2241"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2243"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2244"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2245"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2246"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2247"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u224D"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2254"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2257"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2259"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225A"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225B"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225C"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u225F"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2261"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2268"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2269"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226A"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226A\u0338"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226B"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226B\u0338"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u226D"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2270"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2271"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227A"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227B"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227C"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u227D"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2280"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2281"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22A5"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22B4"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22B5"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22C9"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CA"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CB"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22CC"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u22D4"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D6"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D7"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D8"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22D9"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EA"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EB"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22EC"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u22ED"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u25A0"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25A1"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AA"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AB"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AD"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AE"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25AF"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B0"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B1"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u25B3"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B4"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B5"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B6"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B7"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B8"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25B9"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BC"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BD"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BE"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25BF"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C0"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C1"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C2"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C3"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C4"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C5"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C6"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C7"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C8"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25C9"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CC"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CD"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CE"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25CF"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25D6"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25D7"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u25E6"_ustr, moOpDF::infix, 260, 4, 4, moOpDP::nonedp },
        { u"\u29C0"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29C1"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E3"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E4"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E5"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29E6"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u29F3"_ustr, moOpDF::infix, 260, 3, 3, moOpDP::nonedp },
        { u"\u2A87"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2A88"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AAF"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AAF\u0338"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AB0"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2AB0\u0338"_ustr, moOpDF::infix, 260, 5, 5, moOpDP::nonedp },
        { u"\u2044"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::stretchy },
        { u"\u2206"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u220A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u220D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u220E"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2215"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::stretchy },
        { u"\u2217"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2218"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2219"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u221F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2223"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2236"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2237"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2238"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2239"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u223B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223D\u0331"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u223E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u223F"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2242"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2242\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224E\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u224F\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2250"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2251"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2252"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2253"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2255"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2256"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2258"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u225D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u225E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2263"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2266"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2266\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2267"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u226C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2272"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2273"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2274"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2275"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2276"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2277"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2278"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2279"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u227F\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u228C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228E"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u228F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u228F\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2290"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2290\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2291"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2292"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2293"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2294"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229B"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u229D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22A6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22A7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22AA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22AB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22B9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22BA"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BB"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BC"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BD"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22BE"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u22BF"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u22C4"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C7"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22C8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22CD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22CE"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22CF"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22D1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22D2"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D3"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u22D5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22DF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22E9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22F9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u22FF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u25B2"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2758"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2981"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2982"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A0"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A1"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A2"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A3"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A4"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A5"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A6"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A7"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A8"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29A9"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AA"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AB"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AC"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AD"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AE"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29AF"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B0"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B1"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B2"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B3"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B4"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B5"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29B6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B7"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B8"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29B9"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BA"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BB"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BC"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BD"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BE"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29BF"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C2"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29C3"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29C4"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C5"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C7"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C8"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29C9"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CA"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CB"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CC"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CD"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29CE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29CF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29CF\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D0\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29D6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29D7"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29D8"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29D9"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DB"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DC"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DD"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29DE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29E0"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u29E2"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29E7"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E8"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29E9"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EA"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EB"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EC"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29ED"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29EE"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F0"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F1"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F2"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F5"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F7"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29F8"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29F9"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FA"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FB"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u29FE"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u29FF"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A1D"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A1E"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A1F"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A20"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A21"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"\u2A22"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A23"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A24"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A25"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A26"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A27"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A28"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A29"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2B"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A2E"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A30"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A31"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A32"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A33"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A34"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A35"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A36"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A37"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A38"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A39"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3B"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A3E"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A40"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A41"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A42"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A43"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A44"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A45"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A46"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A47"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A48"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A49"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4B"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4E"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A4F"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A50"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A51"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A52"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A53"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A54"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A55"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A56"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A57"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A58"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A59"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A5A"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5B"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5C"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5D"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5E"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A5F"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A60"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A61"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A62"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A63"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A64"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A65"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A66"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A67"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A68"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A69"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A6F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A70"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A71"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A72"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2A73"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A74"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A75"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A76"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A77"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A78"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A79"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7D\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7E\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A7F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A80"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A81"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A82"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A83"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A84"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A85"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A86"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A89"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A8F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A90"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A91"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A92"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A93"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A94"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A95"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A96"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A97"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A98"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A99"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9A"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9B"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9C"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9D"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9E"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2A9F"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA1\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA2\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AA9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AAE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AB9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ABF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AC9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ACF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AD9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADD"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADD\u0338"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2ADF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE4"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE5"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE6"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AE9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEB"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEC"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AED"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEE"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AEF"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF0"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF1"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF2"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF3"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF4"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF5"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF6"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AF7"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF8"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AF9"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AFA"_ustr, moOpDF::infix, 265, 5, 5, moOpDP::nonedp },
        { u"\u2AFB"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AFD"_ustr, moOpDF::infix, 265, 4, 4, moOpDP::nonedp },
        { u"\u2AFE"_ustr, moOpDF::infix, 265, 3, 3, moOpDP::nonedp },
        { u"|"_ustr, moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"||"_ustr, moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"|||"_ustr, moOpDF::infix, 270, 2, 2, moOpDP::stretchyfence | moOpDP::symmetric },
        { u"\u2190"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2191"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2192"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2193"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2194"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2195"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2196"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2197"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2198"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2199"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u219A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u219B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u219C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u219F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21A7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21A9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21AE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21AF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21B6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21B7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21B8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21B9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21BB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21BC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21BE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21BF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21C8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21C9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21CB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21CD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21CE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21CF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21D0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21D5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21D9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21DA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21DE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21DF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21E0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21E8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21E9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21ED"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21EF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21F1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21F2"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u21F3"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u21F6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21F7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21F9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u21FD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21FE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u21FF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u22B8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u27F0"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u27F1"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u27F5"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F6"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F7"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F8"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27F9"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FA"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FB"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FC"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FD"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FE"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u27FF"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2900"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2901"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2902"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2903"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2904"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2905"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2906"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2907"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2908"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2909"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u290A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u290B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u290C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u290F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2910"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2911"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2912"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2913"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2914"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2915"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2916"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2917"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2918"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2919"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u291F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2920"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2921"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2922"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2923"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2924"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2925"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2926"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2927"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2928"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2929"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u292F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2930"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2931"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2932"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2933"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2934"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2935"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2936"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2937"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2938"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2939"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u293A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u293E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u293F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2940"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2941"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2942"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2943"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2944"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2945"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2946"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2947"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2948"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2949"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u294B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u294C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u294E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u294F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2950"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2951"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2952"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2953"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2954"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2955"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2956"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2957"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2958"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2959"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u295E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u295F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy | moOpDP::accent },
        { u"\u2960"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2961"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2962"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2963"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2964"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2965"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2966"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2967"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2968"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2969"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u296E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u296F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2970"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2971"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2972"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2973"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2974"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2975"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2976"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2977"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2978"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u2979"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297A"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297B"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297C"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297D"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::accent },
        { u"\u297E"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u297F"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2999"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299A"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299B"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299C"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299D"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299E"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u299F"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29DF"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29EF"_ustr, moOpDF::infix, 270, 3, 3, moOpDP::nonedp },
        { u"\u29F4"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::nonedp },
        { u"\u2B45"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"\u2B46"_ustr, moOpDF::infix, 270, 5, 5, moOpDP::stretchy },
        { u"+"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"+"_ustr, moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"-"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"-"_ustr, moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u00B1"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u00B1"_ustr, moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2212"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2212"_ustr, moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2213"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2213"_ustr, moOpDF::prefix, 275, 0, 1, moOpDP::nonedp },
        { u"\u2214"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u229E"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u229F"_ustr, moOpDF::infix, 275, 4, 4, moOpDP::nonedp },
        { u"\u2211"_ustr, moOpDF::prefix, 290, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A0A"_ustr, moOpDF::prefix, 290, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A0B"_ustr, moOpDF::prefix, 290, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222C"_ustr, moOpDF::prefix, 300, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222D"_ustr, moOpDF::prefix, 300, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2295"_ustr, moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2296"_ustr, moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2298"_ustr, moOpDF::infix, 300, 4, 4, moOpDP::nonedp },
        { u"\u2A01"_ustr, moOpDF::prefix, 300, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u222B"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222E"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u222F"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2230"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2231"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2232"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2233"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0C"_ustr, moOpDF::prefix, 310, 0, 1, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0D"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0E"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A0F"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A10"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A11"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A12"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A13"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A14"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A15"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A16"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A17"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A18"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A19"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1A"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1B"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u2A1C"_ustr, moOpDF::prefix, 310, 1, 2, moOpDP::largeop | moOpDP::symmetric },
        { u"\u22C3"_ustr, moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A03"_ustr, moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A04"_ustr, moOpDF::prefix, 320, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C0"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C1"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u22C2"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A00"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A02"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A05"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A06"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A07"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A08"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2A09"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2AFC"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2AFF"_ustr, moOpDF::prefix, 330, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2240"_ustr, moOpDF::infix, 340, 4, 4, moOpDP::nonedp },
        { u"\u220F"_ustr, moOpDF::prefix, 350, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2210"_ustr, moOpDF::prefix, 350, 1, 2, moOpDP::movablelargeop | moOpDP::symmetric },
        { u"\u2229"_ustr, moOpDF::infix, 350, 4, 4, moOpDP::nonedp },
        { u"\u222A"_ustr, moOpDF::infix, 350, 4, 4, moOpDP::nonedp },
        { u"*"_ustr, moOpDF::infix, 390, 3, 3, moOpDP::nonedp },
        { u"."_ustr, moOpDF::infix, 390, 3, 3, moOpDP::nonedp },
        { u"\u00D7"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2022"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2043"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2062"_ustr, moOpDF::infix, 390, 0, 0, moOpDP::nonedp },
        { u"\u22A0"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u22A1"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u22C5"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2A2F"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u2A3F"_ustr, moOpDF::infix, 390, 4, 4, moOpDP::nonedp },
        { u"\u00B7"_ustr, moOpDF::infix, 400, 4, 4, moOpDP::nonedp },
        { u"\u2297"_ustr, moOpDF::infix, 410, 4, 4, moOpDP::nonedp },
        { u"%"_ustr, moOpDF::infix, 640, 3, 3, moOpDP::nonedp },
        { u"\\"_ustr, moOpDF::infix, 650, 0, 0, moOpDP::nonedp },
        { u"\u2216"_ustr, moOpDF::infix, 650, 4, 4, moOpDP::nonedp },
        { u"/"_ustr, moOpDF::infix, 660, 1, 1, moOpDP::nonedp },
        { u"\u00F7"_ustr, moOpDF::infix, 660, 4, 4, moOpDP::nonedp },
        { u"\u2220"_ustr, moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u2221"_ustr, moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u2222"_ustr, moOpDF::prefix, 670, 0, 0, moOpDP::nonedp },
        { u"\u00AC"_ustr, moOpDF::prefix, 680, 2, 1, moOpDP::nonedp },
        { u"\u2299"_ustr, moOpDF::infix, 710, 4, 4, moOpDP::nonedp },
        { u"\u2202"_ustr, moOpDF::prefix, 740, 2, 1, moOpDP::nonedp },
        { u"\u2207"_ustr, moOpDF::prefix, 740, 2, 1, moOpDP::nonedp },
        { u"**"_ustr, moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"<>"_ustr, moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"^"_ustr, moOpDF::infix, 780, 1, 1, moOpDP::nonedp },
        { u"\u2032"_ustr, moOpDF::postfix, 800, 0, 0, moOpDP::nonedp },
        { u"\u266D"_ustr, moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"\u266E"_ustr, moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"\u266F"_ustr, moOpDF::postfix, 800, 0, 2, moOpDP::nonedp },
        { u"!"_ustr, moOpDF::postfix, 810, 1, 0, moOpDP::nonedp },
        { u"!!"_ustr, moOpDF::postfix, 810, 1, 0, moOpDP::nonedp },
        { u"//"_ustr, moOpDF::infix, 820, 1, 1, moOpDP::nonedp },
        { u"@"_ustr, moOpDF::infix, 825, 1, 1, moOpDP::nonedp },
        { u"?"_ustr, moOpDF::infix, 835, 1, 1, moOpDP::nonedp },
        { u"\u2145"_ustr, moOpDF::prefix, 845, 2, 1, moOpDP::nonedp },
        { u"\u2146"_ustr, moOpDF::prefix, 845, 2, 0, moOpDP::nonedp },
        { u"\u221A"_ustr, moOpDF::prefix, 845, 1, 1, moOpDP::stretchy },
        { u"\u221B"_ustr, moOpDF::prefix, 845, 1, 1, moOpDP::nonedp },
        { u"\u221C"_ustr, moOpDF::prefix, 845, 1, 1, moOpDP::nonedp },
        { u"\u2061"_ustr, moOpDF::infix, 850, 0, 0, moOpDP::nonedp },
        { u"\""_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"&"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"\'"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"++"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"--"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"^"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"_"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"`"_ustr, moOpDF::postfix, 880, 0, 00, moOpDP::accent },
        { u"~"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u00A8"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00AA"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00AF"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u00B0"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::nonedp },
        { u"\u00B2"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B3"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B4"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B8"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00B9"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u00BA"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02C6"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02C7"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02C9"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02CA"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02CB"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02CD"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02D8"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02D9"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02DA"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02DC"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u02DD"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u02F7"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u0302"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u0311"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201A"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201B"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201E"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u201F"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2033"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2034"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2035"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2036"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2037"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u203E"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u2057"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u2064"_ustr, moOpDF::infix, 880, 0, 0, moOpDP::nonedp },
        { u"\u20DB"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u20DC"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::accent },
        { u"\u23B4"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23B5"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DC"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DD"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DE"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23DF"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23E0"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"\u23E1"_ustr, moOpDF::postfix, 880, 0, 0, moOpDP::stretchy | moOpDP::accent },
        { u"_"_ustr, moOpDF::infix, 900, 1, 1, moOpDP::nonedp } };

std::vector<moOperatorData> starmathdatabase::moOperatorDataDictionary(
    moOperatorDataDictionaryData, moOperatorDataDictionaryData + starmathdatabase::MATHML_MO_COUNT);

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
