/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.transformer;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.PackageGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.typeparam.ITypeParameterGenerator;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.IPackage;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.transformer.TransformInput;

public interface IWorkingCopyTransformer {
    public static Optional<IAnnotationGenerator<?>> transformAnnotation(IAnnotation a, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, a, () -> a.toWorkingCopy(transformer), (t, i) -> t.transformAnnotation((ITransformInput<IAnnotation, IAnnotationGenerator<?>>)i));
    }

    public static Optional<ICompilationUnitGenerator<?>> transformCompilationUnit(ICompilationUnit icu, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, icu, () -> icu.toWorkingCopy(transformer), (t, i) -> t.transformCompilationUnit((ITransformInput<ICompilationUnit, ICompilationUnitGenerator<?>>)i));
    }

    public static Optional<ITypeParameterGenerator<?>> transformTypeParameter(ITypeParameter param, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, param, () -> param.toWorkingCopy(transformer), (t, i) -> t.transformTypeParameter((ITransformInput<ITypeParameter, ITypeParameterGenerator<?>>)i));
    }

    public static Optional<IMethodParameterGenerator<?>> transformMethodParameter(IMethodParameter mp, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, mp, () -> mp.toWorkingCopy(transformer), (t, i) -> t.transformMethodParameter((ITransformInput<IMethodParameter, IMethodParameterGenerator<?>>)i));
    }

    public static Optional<IFieldGenerator<?>> transformField(IField f, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, f, () -> f.toWorkingCopy(transformer), (t, i) -> t.transformField((ITransformInput<IField, IFieldGenerator<?>>)i));
    }

    public static Optional<IMethodGenerator<?, ?>> transformMethod(IMethod m, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, m, () -> m.toWorkingCopy(transformer), (t, i) -> t.transformMethod((ITransformInput<IMethod, IMethodGenerator<?, ?>>)i));
    }

    public static Optional<ITypeGenerator<?>> transformType(IType type, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, type, () -> type.toWorkingCopy(transformer), (t, i) -> t.transformType((ITransformInput<IType, ITypeGenerator<?>>)i));
    }

    public static Optional<ITypeGenerator<?>> transformUnresolvedType(IUnresolvedType ut, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, ut, () -> ut.toWorkingCopy(transformer), (t, i) -> t.transformUnresolvedType((ITransformInput<IUnresolvedType, ITypeGenerator<?>>)i));
    }

    public static Optional<PackageGenerator> transformPackage(IPackage p, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, p, () -> p.toWorkingCopy(transformer), (t, i) -> t.transformPackage((ITransformInput<IPackage, PackageGenerator>)i));
    }

    public static Optional<ISourceGenerator<IExpressionBuilder<?>>> transformAnnotationElement(IAnnotationElement ae, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, ae, () -> ae.value().toWorkingCopy(transformer), (t, i) -> t.transformAnnotationElement((ITransformInput<IAnnotationElement, ISourceGenerator<IExpressionBuilder<?>>>)i));
    }

    public static Optional<CharSequence> transformImport(IImport imp, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transform(transformer, imp, imp::name, (t, i) -> t.transformImport((ITransformInput<IImport, CharSequence>)i));
    }

    public static <M extends IJavaElement, G> Optional<G> transform(IWorkingCopyTransformer transformer, M model, Supplier<G> defaultGeneratorSupplier, BiFunction<IWorkingCopyTransformer, ITransformInput<M, G>, G> transformerCall) {
        if (transformer == null) {
            return Optional.of(defaultGeneratorSupplier.get());
        }
        return Optional.ofNullable(transformerCall.apply(transformer, new TransformInput<M, G>(model, defaultGeneratorSupplier)));
    }

    public static <G> G remove(ITransformInput<?, G> input) {
        return null;
    }

    default public <G> G remove() {
        return IWorkingCopyTransformer.remove(null);
    }

    public IAnnotationGenerator<?> transformAnnotation(ITransformInput<IAnnotation, IAnnotationGenerator<?>> var1);

    public ICompilationUnitGenerator<?> transformCompilationUnit(ITransformInput<ICompilationUnit, ICompilationUnitGenerator<?>> var1);

    public ITypeParameterGenerator<?> transformTypeParameter(ITransformInput<ITypeParameter, ITypeParameterGenerator<?>> var1);

    public IMethodParameterGenerator<?> transformMethodParameter(ITransformInput<IMethodParameter, IMethodParameterGenerator<?>> var1);

    public IFieldGenerator<?> transformField(ITransformInput<IField, IFieldGenerator<?>> var1);

    public IMethodGenerator<?, ?> transformMethod(ITransformInput<IMethod, IMethodGenerator<?, ?>> var1);

    public ITypeGenerator<?> transformType(ITransformInput<IType, ITypeGenerator<?>> var1);

    public ITypeGenerator<?> transformUnresolvedType(ITransformInput<IUnresolvedType, ITypeGenerator<?>> var1);

    public PackageGenerator transformPackage(ITransformInput<IPackage, PackageGenerator> var1);

    public ISourceGenerator<IExpressionBuilder<?>> transformAnnotationElement(ITransformInput<IAnnotationElement, ISourceGenerator<IExpressionBuilder<?>>> var1);

    public CharSequence transformImport(ITransformInput<IImport, CharSequence> var1);

    public static interface ITransformInput<MODEL extends IJavaElement, GENERATOR> {
        public MODEL model();

        public GENERATOR requestDefaultWorkingCopy();
    }
}

