/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.spliterator.SuperTypeHierarchySpliterator;

public class HierarchicalSpliterator<ELEMENT>
implements Spliterator<ELEMENT> {
    private final Spliterator<IType> m_hierarchySpliterator;
    private final Consumer<? super IType> m_toNextLevelType;
    private final boolean m_oneLevel;
    private Spliterator<ELEMENT> m_levelSpliterator;

    HierarchicalSpliterator(IType startType, boolean includeSuperClasses, boolean includeSuperInterfaces, boolean includeStartType, Function<IType, Spliterator<ELEMENT>> levelSpliteratorProvider) {
        this.m_hierarchySpliterator = new SuperTypeHierarchySpliterator(startType, includeSuperClasses, includeSuperInterfaces, includeStartType);
        this.m_toNextLevelType = nextType -> {
            this.m_levelSpliterator = (Spliterator)levelSpliteratorProvider.apply((IType)nextType);
        };
        this.m_oneLevel = !includeSuperClasses && !includeSuperInterfaces && includeStartType;
        this.moveToNextType();
    }

    @Override
    public boolean tryAdvance(Consumer<? super ELEMENT> action) {
        boolean dataAvailable;
        do {
            boolean classFound;
            boolean bl = dataAvailable = this.m_levelSpliterator != null && this.m_levelSpliterator.tryAdvance(action);
            if (dataAvailable || (classFound = this.moveToNextType())) continue;
            return false;
        } while (!dataAvailable);
        return true;
    }

    protected boolean moveToNextType() {
        return this.m_hierarchySpliterator.tryAdvance(this.m_toNextLevelType);
    }

    @Override
    public Spliterator<ELEMENT> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.isOneLevel()) {
            return this.m_levelSpliterator.estimateSize();
        }
        return this.m_hierarchySpliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        if (this.isOneLevel()) {
            return this.m_levelSpliterator.characteristics();
        }
        return this.m_hierarchySpliterator.characteristics();
    }

    protected boolean isOneLevel() {
        return this.m_oneLevel;
    }
}

