/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.query;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.query.AbstractQuery;
import org.eclipse.scout.sdk.core.model.api.spliterator.SuperTypeHierarchySpliterator;

public class SuperTypeQuery
extends AbstractQuery<IType>
implements Predicate<IType> {
    private final IType m_type;
    private boolean m_includeSelf = true;
    private boolean m_includeSuperClasses = true;
    private boolean m_includeSuperInterfaces = true;
    private ApiFunction<?, ITypeNameSupplier> m_name;
    private String m_simpleName;
    private int m_flags = -1;

    public SuperTypeQuery(IType type) {
        this.m_type = type;
    }

    protected IType getType() {
        return this.m_type;
    }

    public SuperTypeQuery withSelf(boolean b) {
        this.m_includeSelf = b;
        return this;
    }

    protected boolean isIncludeSelf() {
        return this.m_includeSelf;
    }

    public SuperTypeQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperTypeQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public SuperTypeQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public SuperTypeQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    protected int getFlags() {
        return this.m_flags;
    }

    public SuperTypeQuery withName(CharSequence fullyQualifiedName) {
        return this.withNameFrom(null, api -> ITypeNameSupplier.of(fullyQualifiedName));
    }

    public <API extends IApiSpecification> SuperTypeQuery withNameFrom(Class<API> api, Function<API, ITypeNameSupplier> nameFunction) {
        this.m_name = nameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, nameFunction);
        return this;
    }

    protected ApiFunction<?, ITypeNameSupplier> getName() {
        return this.m_name;
    }

    public SuperTypeQuery withSimpleName(String simpleName) {
        this.m_simpleName = simpleName;
        return this;
    }

    protected String getSimpleName() {
        return this.m_simpleName;
    }

    @Override
    public boolean test(IType t) {
        Boolean fqnMatches;
        int flags = this.getFlags();
        if (flags >= 0 && (t.flags() & flags) != flags) {
            return false;
        }
        ApiFunction<?, ITypeNameSupplier> name = this.getName();
        if (name != null && !(fqnMatches = name.apply(t.javaEnvironment()).map(ITypeNameSupplier::fqn).map(fqn -> fqn.equals(t.name())).orElse(false)).booleanValue()) {
            return false;
        }
        String simpleName = this.getSimpleName();
        return simpleName == null || simpleName.equals(t.elementName());
    }

    @Override
    protected Stream<IType> createStream() {
        return StreamSupport.stream(new SuperTypeHierarchySpliterator(this.getType(), this.isIncludeSuperClasses(), this.isIncludeSuperInterfaces(), this.isIncludeSelf()), false).filter(this);
    }
}

