/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.query;

import java.util.Collections;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.query.AbstractQuery;
import org.eclipse.scout.sdk.core.model.api.spliterator.HierarchicalStreamBuilder;
import org.eclipse.scout.sdk.core.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;

public class MethodQuery
extends AbstractQuery<IMethod>
implements Predicate<IMethod> {
    private final IType m_type;
    private boolean m_includeSuperClasses;
    private boolean m_includeSuperInterfaces;
    private String m_methodId;
    private String m_name;
    private ApiFunction<?, ITypeNameSupplier> m_annotation;
    private int m_flags = -1;
    private Pattern m_methodNamePattern;

    public MethodQuery(IType type) {
        this.m_type = type;
    }

    protected static Spliterator<IMethod> findMatchingMethods(IType container, String id) {
        if (id == null) {
            return new WrappingSpliterator<IMethod>(container.unwrap().getMethods());
        }
        for (MethodSpi m : container.unwrap().getMethods()) {
            String methodName = m.getElementName();
            if (!id.startsWith(methodName) || !id.equals(m.wrap().identifier())) continue;
            return new WrappingSpliterator<IMethod>(Collections.singletonList(m));
        }
        return Spliterators.emptySpliterator();
    }

    protected IType getType() {
        return this.m_type;
    }

    public MethodQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public MethodQuery withAnnotation(CharSequence fqn) {
        return this.withAnnotationFrom(null, api -> ITypeNameSupplier.of(fqn));
    }

    public <API extends IApiSpecification> MethodQuery withAnnotationFrom(Class<API> api, Function<API, ITypeNameSupplier> nameFunction) {
        this.m_annotation = nameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, nameFunction);
        return this;
    }

    protected ApiFunction<?, ITypeNameSupplier> getAnnotation() {
        return this.m_annotation;
    }

    public MethodQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    protected int getFlags() {
        return this.m_flags;
    }

    public MethodQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public MethodQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public MethodQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    public MethodQuery withMethodIdentifier(String id) {
        this.m_methodId = id;
        return this;
    }

    protected String getMethodIdentifier() {
        return this.m_methodId;
    }

    public MethodQuery withName(Pattern namePattern) {
        this.m_methodNamePattern = namePattern;
        return this;
    }

    protected Pattern getNamePattern() {
        return this.m_methodNamePattern;
    }

    @Override
    public boolean test(IMethod candidate) {
        String name = this.getName();
        if (name != null && !name.equals(candidate.elementName())) {
            return false;
        }
        int flags = this.getFlags();
        if (flags >= 0 && (candidate.flags() & flags) != flags) {
            return false;
        }
        Pattern namePat = this.getNamePattern();
        if (namePat != null && !namePat.matcher(candidate.elementName()).matches()) {
            return false;
        }
        ApiFunction<?, ITypeNameSupplier> annotation = this.getAnnotation();
        return annotation == null || annotation.apply(candidate.javaEnvironment()).map(ITypeNameSupplier::fqn).map(annotationFqn -> candidate.annotations().withName((CharSequence)annotationFqn).existsAny()).orElse(false) != false;
    }

    @Override
    protected Stream<IMethod> createStream() {
        return new HierarchicalStreamBuilder().withSuperClasses(this.isIncludeSuperClasses()).withSuperInterfaces(this.isIncludeSuperInterfaces()).withStartType(true).build(this.getType(), level -> MethodQuery.findMatchingMethods(level, this.getMethodIdentifier())).filter(this);
    }
}

