/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.query;

import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.query.AbstractQuery;
import org.eclipse.scout.sdk.core.model.api.spliterator.HierarchicalStreamBuilder;
import org.eclipse.scout.sdk.core.model.api.spliterator.WrappingSpliterator;

public class FieldQuery
extends AbstractQuery<IField>
implements Predicate<IField> {
    private final IType m_type;
    private boolean m_includeSuperClasses;
    private boolean m_includeSuperInterfaces;
    private String m_name;
    private int m_flags = -1;

    public FieldQuery(IType type) {
        this.m_type = type;
    }

    protected IType getType() {
        return this.m_type;
    }

    public FieldQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public FieldQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public FieldQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public FieldQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    protected int getFlags() {
        return this.m_flags;
    }

    public FieldQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    @Override
    public boolean test(IField f) {
        String name = this.getName();
        if (name != null && !name.equals(f.elementName())) {
            return false;
        }
        int flags = this.getFlags();
        return flags < 0 || (f.flags() & this.m_flags) == this.m_flags;
    }

    protected static Spliterator<IField> getFieldsSpliterator(IType level) {
        return new WrappingSpliterator<IField>(level.unwrap().getFields());
    }

    @Override
    protected Stream<IField> createStream() {
        return new HierarchicalStreamBuilder().withSuperClasses(this.isIncludeSuperClasses()).withSuperInterfaces(this.isIncludeSuperInterfaces()).withStartType(true).build(this.getType(), FieldQuery::getFieldsSpliterator).filter(this);
    }
}

