/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.model.api.AbstractManagedAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class AnnotationImplementor
extends AbstractJavaElementImplementor<AnnotationSpi>
implements IAnnotation {
    private FinalValue<Map<String, IAnnotationElement>> m_values = new FinalValue();

    public AnnotationImplementor(AnnotationSpi spi) {
        super(spi);
    }

    @Override
    public String name() {
        return this.type().name();
    }

    @Override
    public IType type() {
        return ((AnnotationSpi)this.m_spi).getType().wrap();
    }

    @Override
    public Optional<IAnnotationElement> element(String name) {
        return Optional.ofNullable(this.elements().get(name));
    }

    @Override
    public Map<String, IAnnotationElement> elements() {
        return this.m_values.computeIfAbsentAndGet(() -> {
            Set<Map.Entry<String, AnnotationElementSpi>> entrySet = ((AnnotationSpi)this.m_spi).getValues().entrySet();
            LinkedHashMap<String, IAnnotationElement> values = new LinkedHashMap<String, IAnnotationElement>(entrySet.size());
            for (Map.Entry<String, AnnotationElementSpi> e : entrySet) {
                values.put(e.getKey(), e.getValue().wrap());
            }
            return Collections.unmodifiableMap(values);
        });
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        return this.elements().values().stream();
    }

    @Override
    public IAnnotatable owner() {
        return ((AnnotationSpi)this.m_spi).getOwner().wrap();
    }

    @Override
    public <A extends AbstractManagedAnnotation> A wrap(Class<A> managedAnnotationType) {
        return AbstractManagedAnnotation.wrap(this, managedAnnotationType);
    }

    @Override
    public void internalSetSpi(AnnotationSpi spi) {
        super.internalSetSpi(spi);
        this.m_values = new FinalValue();
    }

    @Override
    public IAnnotationGenerator<?> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return AnnotationGenerator.create(this, transformer);
    }

    @Override
    public IAnnotationGenerator<?> toWorkingCopy() {
        return this.toWorkingCopy(null);
    }
}

