/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class CompilationUnitInfo {
    private static final Path EMPTY_PATH = Paths.get("", new String[0]);
    private final String m_fileName;
    private final Path m_targetDirectory;
    private final Path m_targetFile;
    private final Path m_sourceFolder;
    private final String m_mainTypeName;
    private final String m_package;

    public CompilationUnitInfo(Path sourceFolder, Path sourceFolderRelPath) {
        if (sourceFolder == null) {
            sourceFolder = EMPTY_PATH;
        }
        this.m_sourceFolder = sourceFolder;
        this.m_fileName = sourceFolderRelPath.getFileName().toString();
        this.m_targetFile = sourceFolder.resolve(sourceFolderRelPath);
        this.m_targetDirectory = this.m_targetFile.getParent();
        this.m_mainTypeName = CompilationUnitInfo.computeMainClassName(this.m_fileName);
        Path packagePath = sourceFolderRelPath.getParent();
        this.m_package = packagePath == null ? null : packagePath.toString().replace('/', '.').replace('\\', '.');
    }

    public CompilationUnitInfo(Path sourceFolder, String packageName, String fileName) {
        if (sourceFolder == null) {
            sourceFolder = EMPTY_PATH;
        }
        this.m_sourceFolder = sourceFolder;
        this.m_fileName = Ensure.notBlank(fileName);
        this.m_mainTypeName = CompilationUnitInfo.computeMainClassName(this.m_fileName);
        boolean isDefaultPackage = Strings.isBlank(packageName);
        if (isDefaultPackage) {
            this.m_package = null;
            this.m_targetDirectory = sourceFolder;
        } else {
            this.m_package = packageName;
            this.m_targetDirectory = sourceFolder.resolve(packageName.replace('.', File.separatorChar));
        }
        this.m_targetFile = this.m_targetDirectory.resolve(this.m_fileName);
    }

    private static String computeMainClassName(String fileName) {
        return Strings.removeSuffix(fileName, ".java");
    }

    private static String pathToClasspathString(Path p) {
        return p.toString().replace('\\', '/');
    }

    public String fileName() {
        return this.m_fileName;
    }

    public Path targetDirectory() {
        return this.m_targetDirectory;
    }

    public String targetDirectoryAsString() {
        return CompilationUnitInfo.pathToClasspathString(this.targetDirectory());
    }

    public Path targetFile() {
        return this.m_targetFile;
    }

    public String targetFileAsString() {
        return CompilationUnitInfo.pathToClasspathString(this.targetFile());
    }

    public Path sourceFolder() {
        return this.m_sourceFolder;
    }

    public String sourceDirectoryAsString() {
        return CompilationUnitInfo.pathToClasspathString(this.sourceFolder());
    }

    public String mainTypeSimpleName() {
        return this.m_mainTypeName;
    }

    public String mainTypeFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        String pck = this.packageName();
        if (Strings.hasText(pck)) {
            fqn.append(pck).append('.');
        }
        fqn.append(this.mainTypeSimpleName());
        return fqn.toString();
    }

    public String packageName() {
        return this.m_package;
    }

    public String toString() {
        return CompilationUnitInfo.class.getSimpleName() + " [" + this.targetFileAsString() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompilationUnitInfo that = (CompilationUnitInfo)o;
        return this.m_targetFile.equals(that.m_targetFile) && Objects.equals(this.m_sourceFolder, that.m_sourceFolder);
    }

    public int hashCode() {
        return Objects.hash(this.m_targetFile, this.m_sourceFolder);
    }
}

