/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.imports;

import java.util.Objects;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.Strings;

class TypeReferenceDescriptor {
    private final String m_packageName;
    private final String m_simpleName;
    private final String m_qualifier;
    private final String m_qualifiedName;
    private final boolean m_isTypeArg;
    private final boolean m_isBaseType;

    TypeReferenceDescriptor(CharSequence fqn) {
        this(fqn, false);
    }

    TypeReferenceDescriptor(CharSequence fqn, boolean isTypeArg) {
        this.m_isTypeArg = isTypeArg;
        this.m_isBaseType = JavaTypes.isPrimitive(fqn);
        if (this.isBaseType()) {
            this.m_packageName = null;
            this.m_simpleName = fqn.toString();
            this.m_qualifier = null;
            this.m_qualifiedName = this.m_simpleName;
        } else {
            CharSequence nameWithoutDollar = Strings.replace(fqn, '$', '.');
            String qualifier = JavaTypes.qualifier(fqn);
            String qualifierFromNameWithoutDollar = JavaTypes.qualifier(nameWithoutDollar);
            this.m_qualifier = Strings.isBlank(qualifierFromNameWithoutDollar) ? null : qualifierFromNameWithoutDollar;
            this.m_packageName = Strings.isBlank(qualifier) ? null : qualifier;
            this.m_simpleName = JavaTypes.simpleName(nameWithoutDollar);
            this.m_qualifiedName = Strings.isEmpty(this.m_qualifier) ? this.m_simpleName : this.m_qualifier + "." + this.m_simpleName;
        }
    }

    public boolean isBaseType() {
        return this.m_isBaseType;
    }

    public boolean isTypeArg() {
        return this.m_isTypeArg;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getSimpleName() {
        return this.m_simpleName;
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeReferenceDescriptor [");
        if (this.getPackageName() != null) {
            builder.append("packageName=").append(this.getPackageName()).append(", ");
        }
        builder.append("simpleName=").append(this.getSimpleName()).append(", ");
        if (this.getQualifier() != null) {
            builder.append("qualifier=").append(this.getQualifier()).append(", ");
        }
        builder.append("qualifiedName=").append(this.getQualifiedName()).append(", ").append("isTypeArg=").append(this.isTypeArg()).append(", isBaseType=").append(this.isBaseType()).append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.m_isTypeArg ? 1231 : 1237);
        result = prime * result + (this.m_qualifier == null ? 0 : this.m_qualifier.hashCode());
        result = prime * result + this.m_simpleName.hashCode();
        result = prime * result + (this.m_packageName == null ? 0 : this.m_packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeReferenceDescriptor other = (TypeReferenceDescriptor)obj;
        return this.m_isTypeArg == other.m_isTypeArg && Objects.equals(this.m_qualifier, other.m_qualifier) && Objects.equals(this.m_simpleName, other.m_simpleName) && Objects.equals(this.m_packageName, other.m_packageName);
    }
}

