/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.properties;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public class PropertiesGenerator
implements ISourceGenerator<ISourceBuilder<?>> {
    public static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    private static final Pattern LINE_SEPARATOR_REGEX = Pattern.compile(System.lineSeparator());
    private final Map<String, String> m_properties = new HashMap<String, String>();
    private final List<String> m_headerLines = new ArrayList<String>();

    public static PropertiesGenerator create() {
        return PropertiesGenerator.create((Map<String, String>)null);
    }

    public static PropertiesGenerator create(Map<String, String> properties) {
        return PropertiesGenerator.create(properties, null);
    }

    public static PropertiesGenerator create(Map<String, String> properties, Collection<String> headerLines) {
        return new PropertiesGenerator(properties, headerLines);
    }

    public static PropertiesGenerator create(InputStream in) throws IOException {
        PropertiesGenerator result = new PropertiesGenerator(null, null);
        result.load(in);
        return result;
    }

    protected PropertiesGenerator(Map<String, String> properties, Collection<String> headerLines) {
        if (properties != null) {
            this.m_properties.putAll(properties);
        }
        if (headerLines != null) {
            this.m_headerLines.addAll(headerLines);
        }
    }

    public PropertiesGenerator load(InputStream input) throws IOException {
        char[] content = Strings.toCharArray(Strings.fromInputStream(input, ENCODING));
        try (Reader reader = new BufferedReader(new CharArrayReader(content));){
            this.readHeaderLines((BufferedReader)reader);
        }
        reader = new CharArrayReader(content);
        try {
            this.readProperties(reader);
        }
        finally {
            ((CharArrayReader)reader).close();
        }
        return this;
    }

    public List<String> headerLines() {
        return this.m_headerLines;
    }

    public Map<String, String> properties() {
        return this.m_properties;
    }

    @Override
    public void generate(ISourceBuilder<?> builder) {
        this.m_headerLines.forEach(builder::appendLine);
        this.getAsPropertiesEncodedLines().sorted().forEach(builder::appendLine);
    }

    protected Stream<String> getAsPropertiesEncodedLines() {
        String content;
        Properties prop = new Properties();
        prop.putAll(this.m_properties);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            prop.store(out, null);
            content = out.toString(ENCODING);
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Error encoding properties", e);
        }
        return LINE_SEPARATOR_REGEX.splitAsStream(content).filter(line -> !PropertiesGenerator.isComment(line));
    }

    private static boolean isComment(CharSequence line) {
        return line.charAt(0) == '#' || line.charAt(0) == '!';
    }

    private void readHeaderLines(BufferedReader reader) throws IOException {
        String line;
        this.m_headerLines.clear();
        while ((line = reader.readLine()) != null) {
            CharSequence lineTrimmed = Strings.trim(line);
            if (Strings.isEmpty(lineTrimmed)) {
                this.m_headerLines.add(line);
                continue;
            }
            if (PropertiesGenerator.isComment(lineTrimmed)) {
                this.m_headerLines.add(line);
                continue;
            }
            return;
        }
    }

    private void readProperties(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        this.m_properties.clear();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            this.m_properties.put((String)key, (String)value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesGenerator that = (PropertiesGenerator)o;
        return this.m_properties.equals(that.m_properties) && this.m_headerLines.equals(that.m_headerLines);
    }

    public int hashCode() {
        return Objects.hash(this.m_properties, this.m_headerLines);
    }
}

