/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.member;

import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.generator.AbstractAnnotatableGenerator;
import org.eclipse.scout.sdk.core.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.member.IMemberGenerator;
import org.eclipse.scout.sdk.core.model.api.IMember;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;

public abstract class AbstractMemberGenerator<TYPE extends IMemberGenerator<TYPE>>
extends AbstractAnnotatableGenerator<TYPE>
implements IMemberGenerator<TYPE> {
    private int m_flags;
    private IJavaElementGenerator<?> m_declaringGenerator;

    protected AbstractMemberGenerator() {
    }

    protected AbstractMemberGenerator(IMember member, IWorkingCopyTransformer transformer) {
        super(member, transformer);
        this.withFlags(member.flags());
        member.javaDoc().map(ISourceRange::asCharSequence).map(s -> b -> ((IJavaElementCommentBuilder)b.append((CharSequence)s)).nl()).ifPresent(this::withComment);
    }

    @Override
    public TYPE withFlags(int flags) {
        this.m_flags |= flags;
        return (TYPE)((IMemberGenerator)this.thisInstance());
    }

    @Override
    public int flags() {
        return this.m_flags;
    }

    @Override
    public TYPE withoutFlags(int flags) {
        this.m_flags &= ~flags;
        return (TYPE)((IMemberGenerator)this.thisInstance());
    }

    @Override
    public TYPE asPublic() {
        return this.applyVisibility(1);
    }

    @Override
    public TYPE asPrivate() {
        return this.applyVisibility(2);
    }

    @Override
    public TYPE asProtected() {
        return this.applyVisibility(4);
    }

    @Override
    public TYPE asPackagePrivate() {
        return this.applyVisibility(0);
    }

    protected TYPE applyVisibility(int visibility) {
        this.m_flags &= 0xFFFFFFF8;
        return this.withFlags(visibility);
    }

    @Override
    public TYPE asStatic() {
        return this.withFlags(8);
    }

    @Override
    public TYPE asFinal() {
        return this.withFlags(16);
    }

    @Override
    public Optional<IJavaElementGenerator<?>> declaringGenerator() {
        return Optional.ofNullable(this.m_declaringGenerator);
    }

    public TYPE withDeclaringGenerator(IJavaElementGenerator<?> parent) {
        this.m_declaringGenerator = parent;
        return (TYPE)((IMemberGenerator)this.thisInstance());
    }
}

