/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.imports.ImportCollector;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IArrayMetaValue;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.JavaTypes;

public final class SimpleGenerators {
    private SimpleGenerators() {
    }

    public static ISourceGenerator<ISourceBuilder<?>> createImportGenerator(IImport imp) {
        return ISourceGenerator.raw(ImportCollector.createImportDeclaration(imp.isStatic(), imp.name()));
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createMetaValueGenerator(IMetaValue mv, IWorkingCopyTransformer transformer) {
        switch (mv.type()) {
            case Null: {
                return b -> b.append("null");
            }
            case Int: {
                return b -> b.append(mv.as(Integer.class));
            }
            case Byte: {
                return b -> b.append(mv.as(Byte.class).byteValue());
            }
            case Short: {
                return b -> b.append(mv.as(Short.class).shortValue());
            }
            case Char: {
                return b -> ((IExpressionBuilder)((IExpressionBuilder)b.append('\'')).append(mv.as(Character.class).charValue())).append('\'');
            }
            case Float: {
                return b -> ((IExpressionBuilder)b.append(mv.as(Float.class).floatValue())).append('f');
            }
            case Double: {
                return b -> b.append(mv.as(Double.class));
            }
            case Bool: {
                return b -> b.append(mv.as(Boolean.class));
            }
            case Long: {
                return b -> ((IExpressionBuilder)b.append(mv.as(Long.class))).append('L');
            }
            case String: {
                return b -> b.stringLiteral(mv.as(String.class));
            }
            case Type: {
                return b -> b.classLiteral(mv.as(IType.class).reference(true));
            }
            case Enum: {
                IField field = mv.as(IField.class);
                return b -> b.enumValue(field.requireDeclaringType().name(), field.elementName());
            }
            case Annotation: {
                return IWorkingCopyTransformer.transformAnnotation(mv.as(IAnnotation.class), transformer).map(g -> b -> b.append((ISourceGenerator<ISourceBuilder<?>>)g)).orElseGet(ISourceGenerator::empty);
            }
            case Array: {
                return SimpleGenerators.createArrayMetaValueGenerator((IArrayMetaValue)mv, transformer);
            }
        }
        return b -> ((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)b.append("UNKNOWN(")).append(mv.type().toString())).append(", ")).append(mv.toString())).append(')');
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createArrayMetaValueGenerator(IArrayMetaValue mv, IWorkingCopyTransformer transformer) {
        IMetaValue[] metaArray = mv.metaValueArray();
        List<ISourceGenerator> generators = Arrays.stream(metaArray).map(m -> SimpleGenerators.createMetaValueGenerator(m, transformer)).map(g -> g.generalize(ExpressionBuilder::create)).toList();
        boolean useNewlines = metaArray.length > 0 && (metaArray[0].type() == MetaValueType.Array || metaArray[0].type() == MetaValueType.Annotation);
        return b -> b.array(generators.stream(), useNewlines);
    }

    public static ISourceGenerator<IExpressionBuilder<?>> createAnnotationElementGenerator(IAnnotationElement ae, IWorkingCopyTransformer transformer) {
        if (ae.isDefault()) {
            return ISourceGenerator.empty();
        }
        return b -> ((IExpressionBuilder)((IExpressionBuilder)b.append(ae.elementName())).equalSign()).append(ae.value().toWorkingCopy(transformer).generalize(ExpressionBuilder::create));
    }

    public static ITypeGenerator<?> createUnresolvedTypeGenerator(IUnresolvedType ut, IWorkingCopyTransformer transformer) {
        return ut.type().map(t -> TypeGenerator.create(t, transformer)).orElseGet(() -> (ITypeGenerator)TypeGenerator.create().setDeclaringFullyQualifiedName(JavaTypes.qualifier(ut.name().replace('$', '.'))).withElementName(ut.elementName()));
    }
}

