/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder.java.comment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.SourceBuilderWrapper;
import org.eclipse.scout.sdk.core.builder.java.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public class CommentBuilder<TYPE extends ICommentBuilder<TYPE>>
extends SourceBuilderWrapper<TYPE>
implements ICommentBuilder<TYPE> {
    private static final Pattern REGEX_COMMENT_PATTERN1 = Pattern.compile("^s*/\\*\\*?s*$");
    private static final Pattern REGEX_COMMENT_PATTERN2 = Pattern.compile("^s*\\*\\*?/s*$");
    private static final Pattern REGEX_COMMENT_PATTERN3 = Pattern.compile("^s*\\*.*$");

    protected CommentBuilder(ISourceBuilder<?> inner) {
        super(inner);
    }

    public static ICommentBuilder<?> create(ISourceBuilder<?> inner) {
        return new CommentBuilder(inner);
    }

    @Override
    public TYPE appendBlockCommentStart() {
        return (TYPE)((ICommentBuilder)this.append("/*"));
    }

    @Override
    public TYPE appendJavaDocStart() {
        return (TYPE)((ICommentBuilder)this.appendBlockCommentStart().append('*'));
    }

    @Override
    public TYPE appendBlockCommentEnd() {
        return (TYPE)((ICommentBuilder)this.append("*/"));
    }

    @Override
    public TYPE appendTodo(CharSequence toDoMessage) {
        StringBuilder msg = new StringBuilder("TODO ");
        String username = CoreUtils.getUsername();
        if (Strings.hasText(username)) {
            msg.append('[').append(username).append("] ");
        }
        msg.append(Ensure.notNull(toDoMessage));
        return this.appendSingleLineComment(msg);
    }

    @Override
    public TYPE appendSingleLineComment(CharSequence msg) {
        return (TYPE)((ICommentBuilder)((ICommentBuilder)((ICommentBuilder)this.append("// ")).append(msg)).nl());
    }

    @Override
    public TYPE appendTodoAutoGeneratedMethodStub() {
        return this.appendTodo("Auto-generated method stub.");
    }

    @Override
    public TYPE appendJavaDocLine(CharSequence comment) {
        return ((ICommentBuilder)((ICommentBuilder)((ICommentBuilder)this.appendJavaDocStart().space()).append(comment)).space()).appendBlockCommentEnd();
    }

    @Override
    public TYPE appendJavaDocComment(String comment) {
        return this.appendBlockComment(comment, true);
    }

    @Override
    public TYPE appendBlockComment(String comment) {
        return this.appendBlockComment(comment, false);
    }

    protected TYPE appendBlockComment(String comment, boolean isJavaDoc) {
        if (isJavaDoc) {
            this.appendJavaDocStart();
        } else {
            this.appendBlockCommentStart();
        }
        this.nl();
        try (BufferedReader inputReader = new BufferedReader(new StringReader(comment));){
            String line = inputReader.readLine();
            while (line != null) {
                if (!REGEX_COMMENT_PATTERN1.matcher(line).matches() && !REGEX_COMMENT_PATTERN2.matcher(line).matches()) {
                    if (REGEX_COMMENT_PATTERN3.matcher(line).matches()) {
                        this.append(line);
                    } else {
                        ((ICommentBuilder)this.append("* ")).append(line);
                    }
                    this.nl();
                }
                line = inputReader.readLine();
            }
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Unable to format comment.", e);
        }
        return (TYPE)((ICommentBuilder)this.appendBlockCommentEnd().nl());
    }
}

