/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder.java;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportValidator;
import org.eclipse.scout.sdk.core.imports.ImportCollector;
import org.eclipse.scout.sdk.core.imports.ImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.PropertySupport;

public class JavaBuilderContext
implements IJavaBuilderContext {
    private final IImportValidator m_validator;
    private final IJavaEnvironment m_env;
    private final IBuilderContext m_inner;

    public JavaBuilderContext() {
        this(null, null, null);
    }

    public JavaBuilderContext(IBuilderContext inner) {
        this(inner, null, null);
    }

    public JavaBuilderContext(IJavaEnvironment env) {
        this(null, env, null);
    }

    public JavaBuilderContext(IBuilderContext inner, IJavaEnvironment env) {
        this(inner, env, null);
    }

    public JavaBuilderContext(IBuilderContext inner, IImportValidator validator) {
        this(inner, Optional.ofNullable(validator).map(IImportValidator::importCollector).flatMap(IImportCollector::getJavaEnvironment).orElse(null), validator);
    }

    protected JavaBuilderContext(IBuilderContext inner, IJavaEnvironment env, IImportValidator validator) {
        this.m_inner = Optional.ofNullable(inner).orElseGet(BuilderContext::new);
        this.m_env = env;
        this.m_validator = Optional.ofNullable(validator).orElseGet(() -> new ImportValidator(new ImportCollector(this)));
    }

    @Override
    public Optional<IJavaEnvironment> environment() {
        return Optional.ofNullable(this.m_env);
    }

    @Override
    public String lineDelimiter() {
        return this.builderContext().lineDelimiter();
    }

    @Override
    public PropertySupport properties() {
        return this.builderContext().properties();
    }

    @Override
    public IImportValidator validator() {
        return this.m_validator;
    }

    @Override
    public <A extends IApiSpecification> Optional<A> api(Class<A> apiDefinition) {
        return this.environment().flatMap(env -> env.api(apiDefinition));
    }

    @Override
    public <A extends IApiSpecification> A requireApi(Class<A> apiDefinition) {
        return (A)this.environment().map(env -> env.requireApi(apiDefinition)).orElseThrow(() -> Ensure.newFail("Cannot compute API because no Java environment is available.", new Object[0]));
    }

    public IBuilderContext builderContext() {
        return this.m_inner;
    }

    public int hashCode() {
        int prime = 31;
        int h = prime + (this.m_env == null ? 0 : this.m_env.hashCode());
        return prime * h + this.m_inner.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaBuilderContext other = (JavaBuilderContext)obj;
        return Objects.equals(this.m_env, other.m_env) && Objects.equals(this.m_inner, other.m_inner);
    }
}

